/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 */

import React, {useEffect, useState} from 'react';
import {SafeAreaView, useColorScheme} from 'react-native';

import NetInfo from '@react-native-community/netinfo';
import {LocaleConfig} from 'react-native-calendars';
import Toast from 'react-native-toast-message';
import {Colors} from 'react-native/Libraries/NewAppScreen';
import {Provider} from 'react-redux';
import store from './src/app/store';
import NoConnection from './src/components/noconnection/NoConnection';
import AppNavigation from './src/navigation/AppNavigation';
function App(): React.JSX.Element {
  const isDarkMode = useColorScheme() === 'dark';

  const backgroundStyle = {
    flex: 1,
    backgroundColor: isDarkMode ? Colors.darker : Colors.lighter,
  };
  const [connectionStatus, setConnetionStatus] = useState(true);
  LocaleConfig.locales['vn'] = {
    monthNames: [
      'Tháng 1',
      'Tháng 2',
      'Tháng 3',
      'Tháng 4',
      'Tháng 5',
      'Tháng 6',
      'Tháng 7',
      'Tháng 8',
      'Tháng 9',
      'Tháng 10',
      'Tháng 11',
      'Tháng 12',
    ],
    monthNamesShort: [
      'Tháng 1',
      'Tháng 2',
      'Tháng 3',
      'Tháng 4',
      'Tháng 5',
      'Tháng 6',
      'Tháng 7',
      'Tháng 8',
      'Tháng 9',
      'Tháng 10',
      'Tháng 11',
      'Tháng 12',
    ],
    dayNames: ['Thứ 2', 'Thứ T3', 'Thứ T4', 'Thứ T5', 'Thứ T6', 'Thứ T7', 'CN'],
    dayNamesShort: ['T2', 'T3', 'T4', 'T5', 'T6', 'T7', 'CN'],
    today: 'Ngày hôm nay',
  };
  LocaleConfig.defaultLocale = 'vn';
  useEffect(() => {
    const unsubscribe = NetInfo.addEventListener(state => {
      if (
        state.isInternetReachable == true ||
        state.isInternetReachable == null
      ) {
        setConnetionStatus(true);
      } else {
        setConnetionStatus(false);
      }
    });

    return () => {
      unsubscribe();
    };
  }, []);

  return (
    <Provider store={store}>
      <SafeAreaView style={backgroundStyle}>
        {!connectionStatus && <NoConnection isShow={!connectionStatus} />}
        <AppNavigation />
        <Toast />
      </SafeAreaView>
    </Provider>
  );
}

export default App;
