import axiosClient from '../network/axios';

const authAPI = {
  requestConfirmOTP: ({otp, email}) =>
    axiosClient.post('check-otp', {otp, email}),

  requestSendMail: email =>
    axiosClient.post('users/forgotPassword?username=ntdung899@gmail.com'),

  requestChangePassword: payload => axiosClient.post('reset-password', payload),

  requestAuthenticate: ({username, password}) =>
    axiosClient.post(
      `authenticate/authenticate?username=${username}&password=${password}`,
    ),

  requestLogout: () => axiosClient.post('authenticate/logout'),

  requestGetMyInfo: () => axiosClient.get('authenticate/getMyInfo'),
  requestGetCompanyLogo: () => axiosClient.get('companyInfo'),
};

export default authAPI;
