import axiosClient from '../network/axios';

const confirmDateAPI = {
  requestGetConfirmDay: (page, pageSize) =>
    axiosClient.get(`myAbsentRequests?Page=${page}&PageSize=${pageSize}`),
  requestGetConfirmApprovedDate: ({filter, sort, page, pageSize}) =>
    axiosClient.get(
      `myAbsentApprovalRequests?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetAbsentChart: () => axiosClient.get('myAbsentRequests/statistic'),
  requestPostConfirmWorkingDay: payload =>
    axiosClient.post('absentRequests', payload),
  requestPostApproveConfirmWorkingDay: ({id}) =>
    axiosClient.post(`absentRequests/${id}/approve?comment=&nextApproverId=`),
  requestMyAbsentRequest: ({page, pageSize}) =>
    axiosClient.get(
      `myAbsentRequests?Filters=&Sorts=-start&Page=${page}&PageSize=${pageSize}`,
    ),
};

export default confirmDateAPI;
