import axiosClient from '../network/axios';

const homeAPI = {
  requestGetQuotation: () => {
    return axiosClient.get(`getAllQuote`);
  },
  requestGetRandomQuotation: () => {
    return axiosClient.get(`getRandomQuotation`);
  },
  requestGetUsersDirectManagers: () => {
    return axiosClient.get(`myDirectManagers`);
  },
  requestGetBirthdayUser: ({month, year}) =>
    axiosClient.get(`users/statistics/birthday?year=${year}&month=${month}`),
};

export default homeAPI;
