import axiosClient from '../network/axios';
export default {
  requestGetLeavesDay: ({filter, sort, page, pageSize}) =>
    axiosClient.get(
      `myLeaveDays?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetRestDay: () => axiosClient.get('myLeaveRestDays'),
  requestGetLeaveDayApproved: ({filter, sort, page, pageSize}) =>
    axiosClient.get(
      `myLeaveDayApprovalRequests?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetLeaveCategory: () => axiosClient.get('leaveCategories'),
  requestGetDirectManagers: () => axiosClient.get('myDirectManagers'),
  requestPostLeaveRequest: payload => axiosClient.post('leaveDays', payload),
  requestPostApproveLeaveRequest: ({id}) =>
    axiosClient.post(`leaveDays/${id}/approve?comment=`),
};
