import {configureStore} from '@reduxjs/toolkit';

import authReducer from '../screens/authentication/authSlice';
import loaderReducer from './loaderSlice';
import homeReducer from '../screens/home/homeSlice';
import onLeaveReducer from '../screens/onleave/onLeaveSlice';
import confirmDateReducer from '../screens/confirm_date/confirmDateSlice';
import notificationReducer from '../screens/notification/notificationSlice';

const rootReducer = {
  loader: loaderReducer,
  auth: authReducer,
  home: homeReducer,
  onLeave: onLeaveReducer,
  confirmDate: confirmDateReducer,
  notification: notificationReducer,
};

const store = configureStore({
  reducer: rootReducer,
  middleware: getDefaultMiddleware =>
    getDefaultMiddleware({
      serializableCheck: false,
    }),
});
export default store;
