import React from 'react';
import {Text} from 'react-native-paper';
import {fonts} from '../../assets/fonts/fonts';
import colors from '../../values/colors';

const FONT_FAMILY_BASE = fonts.beProLight;

const AppText = ({
  variant,
  children,
  style,
  onPress,
  color,
  isSubText,
  size,
  isTitle,
}) => {
  const defaultStyle = {
    fontFamily: isTitle ? fonts.beProBold : FONT_FAMILY_BASE,
    fontSize: isSubText ? 12 : size || 14,
    color: color ?? colors.textColor,
  };
  return (
    <Text variant={variant} style={[defaultStyle, style]} onPress={onPress}>
      {children}
    </Text>
  );
};
export default AppText;
