import React from 'react';
import { Image, StyleSheet, TouchableOpacity, View } from 'react-native';
import AppText from './AppText';
export default function ButtonComponent({
  text,
  style,
  textStyle,
  iconSource,
  styleIcon,
  onPress,
  rightIcon,
  leftIcon,
  badge,
  badgeStyle,
  disable,
}) {
  return (
    <TouchableOpacity style={style} disabled={disable} onPress={onPress}>
      {leftIcon && <Image source={leftIcon} style={styleIcon} />}
      {text && <AppText style={textStyle}>{text}</AppText>}
      {iconSource && <Image source={iconSource} style={styleIcon} />}
      {rightIcon && <Image source={rightIcon} style={styleIcon} />}
      {badge && (
        <View style={badgeStyle}>
          <AppText style={{color: 'white', fontSize: 12}}>{badge}</AppText>
        </View>
      )}
    </TouchableOpacity>
  );
}
const styles = StyleSheet.create({});
