import React, {useState} from 'react';
import {Image, StyleSheet, Text, View} from 'react-native';
import {Dropdown} from 'react-native-element-dropdown';
import {IMAGES} from '../../values/images';
import AppText from '../AppText';
import colors from '../../values/colors';

const data = [
  {label: 'Item 1', value: '1'},
  {label: 'Item 2', value: '2'},
  {label: 'Item 3', value: '3'},
  {label: 'Item 4', value: '4'},
  {label: 'Item 5', value: '5'},
  {label: 'Item 6', value: '6'},
  {label: 'Item 7', value: '7'},
  {label: 'Item 8', value: '8'},
];

const SelectDropdownComponent = ({
  selectData = [],
  value,
  setValue,
  width,
  height,
  disable = false,
}) => {
  //   const [value, setValue] = useState(null);
  const [isFocus, setIsFocus] = useState(false);

  return (
    <View style={styles.container}>
      <Dropdown
        disable={disable}
        style={[
          styles.dropdown,
          {width: width ?? 100, height: height ?? 40},
          isFocus && {borderColor: 'blue'},
        ]}
        itemTextStyle={{color: colors.textColor}}
        placeholderStyle={styles.placeholderStyle}
        selectedTextStyle={styles.selectedTextStyle}
        inputSearchStyle={styles.inputSearchStyle}
        iconStyle={styles.iconStyle}
        data={selectData ?? data}
        maxHeight={300}
        labelField="label"
        valueField="value"
        placeholder={
          !isFocus
            ? selectData.length > 0
              ? selectData[0].label
              : 'Select'
            : '...'
        }
        value={value}
        onFocus={() => setIsFocus(true)}
        onBlur={() => setIsFocus(false)}
        onChange={item => {
          setValue(item.value);
          setIsFocus(false);
        }}
      />
    </View>
  );
};

export default SelectDropdownComponent;

const styles = StyleSheet.create({
  container: {
    backgroundColor: 'white',
  },
  dropdown: {
    borderColor: 'gray',
    borderWidth: 0.5,
    borderRadius: 8,
    paddingHorizontal: 8,
    color: colors.textColor,
  },
  icon: {
    marginRight: 5,
  },

  placeholderStyle: {
    fontSize: 16,
    color: colors.textColor,
  },
  selectedTextStyle: {
    fontSize: 16,
    color: colors.textColor,
  },
  iconStyle: {
    width: 20,
    height: 20,
  },
  inputSearchStyle: {
    height: 40,
    fontSize: 16,
    color: colors.textColor,
  },
});
