import React from 'react';
import { StyleSheet, Text, View } from 'react-native';
import { PanGestureHandler } from 'react-native-gesture-handler';
import Animated from 'react-native-reanimated'
const ListView = (arr) => {
    return (
        <View>
            <PanGestureHandler>
                <Animated.View style={styles.item}>
                    <View style={{ flex: 3 }}>
                        <SelectDropdown
                            data={Socials}
                            dropdownIconPosition={'right'}
                            defaultButtonText={item.type}
                            buttonStyle={styles.dropdown1BtnStyle}
                            onSelect={(selectedItem, item_index) =>
                                onChangeDropDownContactUser(selectedItem, index)
                            }
                            dropdownStyle={styles.dropdown1DropdownStyle}
                            rowStyle={styles.dropdown1RowStyle}
                            rowTextStyle={styles.dropdown1RowTxtStyle}
                            buttonTextStyle={styles.dropdown1BtnTxtStyle}
                            renderDropdownIcon={isOpened => {
                                return <Image source={isOpened ? IMAGES.IcUpArrow : IMAGES.IcDownArrow} style={{ width: 20, height: 20 }} />
                            }
                            }
                        />
                    </View>
                    <View style={{ flex: 5 }}>
                        <TextInputComponent
                            styleAreaInput={{ backgroundColor: 'white' }}
                            placeholder={`${item.type} contact`}
                            keyboardType={'email-address'}
                            autoCapitalize="none"
                            value={item.contact_unique_id}
                            onChangeText={(text) => onChangeInputContactUser(text, index)} />
                    </View>
                </Animated.View>
            </PanGestureHandler>
        </View>
    )
}
const styles = StyleSheet.create({
    container: {
        width: '100%',
        alignItems: 'center',

    },
    item: {
        width: '90%',
        height: 70,
        marginVertical: 10,
        justifyContent: 'center',
        paddingLeft: 20,
        backgroundColor: '#FFFFFF',
        borderRadius: 10,

        shadowOpacity: 0.08,
        shadowOffset: {
            width: 0,
            height: 20
        },
        shadowRadius: 10,
        elevation: 5,
    }

})