/* eslint-disable prettier/prettier */
import React, {memo, useEffect, useState} from 'react';
import {
  Image,
  ImageBackground,
  SafeAreaView,
  TouchableOpacity,
} from 'react-native';
import {useDispatch} from 'react-redux';
import RootNavigation from '../../navigation/RootNavigation';
import api from '../../network/axios';
import {APP_NAVIGATE_SCREEN} from '../../utils/constant';
import {IMAGES} from '../../values/images';
import styles from './style';
import config from '../../config';
import Utils from '../../utils';
import {getCompanyInfo} from '../../screens/authentication/authSlice';

const HeaderComponent = React.memo(() => {
  const dispatch = useDispatch();

  const [logo, setLogo] = useState();

  const navigateHome = () => {
    RootNavigation.navigate(APP_NAVIGATE_SCREEN.HOME);
  };

  const getCompanyLogo = async () => {
    const res = await dispatch(getCompanyInfo());
    const {success} = Utils.getValues(res, 'payload', false);
    if (success) {
      const {data} = Utils.getValues(res, 'payload', false);
      setLogo(config.imageEndPoint + data.logo);
    }
  };
  useEffect(() => {
    getCompanyLogo();
  }, []);
  return (
    <SafeAreaView>
      <ImageBackground style={styles.container} source={IMAGES.BgHeader}>
        <TouchableOpacity
          onPress={navigateHome}
          style={{flex: 1, alignItems: 'center'}}>
          {logo && <Image source={{uri: logo}} style={styles.iconLogo} />}
        </TouchableOpacity>
      </ImageBackground>
    </SafeAreaView>
  );
});

export default memo(HeaderComponent);
