import React from 'react';
import {Linking, Platform, SafeAreaView, StyleSheet} from 'react-native';
//Screen
//Values
import Alert from 'react-native-awesome-alerts';
function NoConnection({isShow}) {
  const onOpenSetting = () => {
    Platform.OS === 'ios'
      ? Linking.openURL('App-Prefs:Wifi')
      : // Linking.openSettings('app-settings:');
        Linking.sendIntent('android.settings.SETTINGS');
  };

  return (
    <SafeAreaView style={styles.container}>
      <Alert
        show={isShow}
        showProgress={false}
        title={'Hệ thống'}
        message={'Vui lòng đổi wifi hoặc sử dụng 4G'}
        closeOnTouchOutside={false}
        closeOnHardwareBackPress={false}
        showConfirmButton={true}
        confirmText="Open setting"
        confirmButtonColor="#DD6B55"
        onConfirmPressed={onOpenSetting}
      />
    </SafeAreaView>
  );
}
const styles = StyleSheet.create({
  container: {},
  mainView: {
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'white',
  },
  textWrapper: {
    justifyContent: 'center',
    alignItems: 'center',
    flexDirection: 'row',
  },
  text: {
    textAlign: 'center',
    marginLeft: 50,
    marginRight: 50,
    color: 'black',
  },
  emptyView: {flex: 2, backgroundColor: 'white'},
});
export default NoConnection;
