import {NavigationContainer} from '@react-navigation/native';
import {createNativeStackNavigator} from '@react-navigation/native-stack';
import * as React from 'react';
import ForgotPassword from '../screens/authentication/forgot_password/ForgotPasswordContainer';
import IntroScreen from '../screens/authentication/introduction/IntroductionContainer';
import LoginScreen from '../screens/authentication/login/LoginContainer';
import ServerScreen from '../screens/authentication/server/ServerContainer';
import SignUpScreen from '../screens/authentication/signup/SignUpContainer';
import SplashContainer from '../screens/authentication/splash/SlashContainer';
import ProfileContainer from '../screens/profile/ProfileContainer';
import SalaryScreen from '../screens/salary/SalaryContainer';
import ConfirmedShiftDetail from '../screens/shift/shift-tabs/ConfirmedShiftScreen/ConfirmedShiftDetail/ConfirmedShiftDetailContainer';

import {APP_NAVIGATE_SCREEN} from '../utils/constant';
import BottomTabs from './BottomTabNavigation';
import RootNavigation from './RootNavigation';
import HomeScreen from '../screens/home';
import ChatAssistantScreen from '../screens/chat_assistant';

const {
  INTRO,
  SERVER,
  LOGIN,
  MAIN,
  SIGN_UP,
  SPLASH,
  PROFILE,
  FORGOT_PASS,
  CONFIRM_SHIFT_DETAIL,
  SALARY,
  HOME,
  CHAT_ASSISTANT,
} = APP_NAVIGATE_SCREEN;
const AppScreen = {
  [SPLASH]: SplashContainer,
  [SERVER]: ServerScreen,
  [LOGIN]: LoginScreen,
  [SIGN_UP]: SignUpScreen,
  [PROFILE]: ProfileContainer,
  [FORGOT_PASS]: ForgotPassword,
  // [MAIN]: Tabs,
  [MAIN]: BottomTabs,
  [CONFIRM_SHIFT_DETAIL]: ConfirmedShiftDetail,
  [SALARY]: SalaryScreen,
  [INTRO]: IntroScreen,
  [HOME]: HomeScreen,
  [CHAT_ASSISTANT]: ChatAssistantScreen,
};
const Stack = createNativeStackNavigator();

function AppNavigation() {
  return (
    <NavigationContainer
      linking={{
        prefixes: 'anawork://app',
      }}
      ref={navigatorRef => {
        RootNavigation.setTopLevelNavigator(navigatorRef);
      }}>
      <Stack.Navigator
        initialRouteName={SPLASH}
        screenOptions={{headerShown: false}}>
        {Object.keys(AppScreen).map((item, index) => (
          <Stack.Screen key={index} name={item} component={AppScreen[item]} />
        ))}
      </Stack.Navigator>
    </NavigationContainer>
  );
}

export default AppNavigation;
