import {createBottomTabNavigator} from '@react-navigation/bottom-tabs';
import * as React from 'react';
import {Image} from 'react-native';
import {useSelector} from 'react-redux';
import {authSelector} from '../app/selectors';
import HeaderComponent from '../components/header/HeaderComponent';
import config from '../config';
import NotificationScreen from '../screens/notification';
import ProfileScreen from '../screens/profile';
import {APP_NAVIGATE_SCREEN} from '../utils/constant';
import {IconDrawer, IMAGES} from '../values/images';
import TopTabNavigation from './TopTabNavigation';

const {HOME, SHIFT, PROFILE, DAY_WAGE, Notification} = APP_NAVIGATE_SCREEN;

const AppScreen = {
  [HOME]: TopTabNavigation,
  [Notification]: NotificationScreen,
  // [DAY_WAGE]: DayWageNavigation,
  //[SHIFT]: DayWageNavigation,
  [PROFILE]: ProfileScreen,
};
const AppIcon = {
  [HOME]: IconDrawer.IcOverview,
  [Notification]: IconDrawer.IcNotificationColor,
  //[DAY_WAGE]: IconDrawer.IcDataSheet,
  //[SHIFT]: IconDrawer.IcDataSheet,
  [PROFILE]: IconDrawer.IcLeave,
};

const Tab = createBottomTabNavigator();

export default function BottomNavigation() {
  const authSelect = useSelector(authSelector);
  const {userInfo} = authSelect;
  return (
    <Tab.Navigator screenOptions={{scrollEnabled: true}}>
      {Object.keys(AppScreen).map((item, index) => (
        <Tab.Screen
          key={index}
          name={item}
          component={AppScreen[item]}
          options={{
            header: props => <HeaderComponent />,
            tabBarActiveTintColor: '#3947e9', // tab text color
            tabBarLabelPosition: 'below-icon',
            tabBarShowLabel: true,
            tabBarIcon: ({focused, size}) =>
              index === 2 ? (
                <Image
                  source={
                    userInfo?.avatar
                      ? {uri: config.imageEndPoint + userInfo?.avatar}
                      : IMAGES.IcAvatarDefault
                  }
                  style={{
                    width: 30,
                    height: 30,
                    borderRadius: 30,
                    borderWidth: 1,
                    borderColor: focused ? 'blue' : 'grey',
                    resizeMode: 'contain',
                  }}
                />
              ) : (
                <Image source={AppIcon[item]} style={{width: 24, height: 24}} />
              ),
          }}
        />
      ))}
    </Tab.Navigator>
  );
}
