import {createDrawerNavigator} from '@react-navigation/drawer';
import * as React from 'react';
import {Image} from 'react-native';

import HeaderComponent from '../components/header/HeaderComponent';
import ConfirmDate from '../screens/confirm_date/ConfirmDateContainer';
import HomeScreen from '../screens/home/homeContainer';
import OnLeave from '../screens/onleave/onLeaveContainer';
import Overtime from '../screens/overtime/OvertimeContainer';
import SalaryScreen from '../screens/salary/SalaryContainer';
import ShiftScreen from '../screens/shift/ShiftContainer';
import WorkLoad from '../screens/workload/WorkLoadContainer';
import {APP_NAVIGATE_SCREEN} from '../utils/constant';
import {IconDrawer} from '../values/images';
const {
  HOME,
  SHIFT,
  PERSONNEL,
  ON_LEAVE,
  OVERTIME,
  SALARY,
  CONFIRM_DATE,
  WORK_LOAD,
} = APP_NAVIGATE_SCREEN;

const AppScreen = {
  [HOME]: HomeScreen,
  [ON_LEAVE]: OnLeave,
  [OVERTIME]: Overtime,
  [SALARY]: SalaryScreen,
  [CONFIRM_DATE]: ConfirmDate,
  [SHIFT]: ShiftScreen,
  [WORK_LOAD]: WorkLoad,
};
const AppIcon = {
  [HOME]: IconDrawer.IcOverview,
  [ON_LEAVE]: IconDrawer.IcLeave,
  [OVERTIME]: IconDrawer.IcOvertime,
  [SALARY]: IconDrawer.IcSalary,
  [CONFIRM_DATE]: IconDrawer.IcConfirmDay,
  [SHIFT]: IconDrawer.IcShift,
  [WORK_LOAD]: IconDrawer.IcDataSheet,
};
const Drawer = createDrawerNavigator();

export default function App() {
  return (
    <Drawer.Navigator initialRouteName={HOME}>
      {Object.keys(AppScreen).map((item, index) => (
        <Drawer.Screen
          key={index}
          name={item}
          component={AppScreen[item]}
          options={{
            header: props => <HeaderComponent {...props} />,
            drawerIcon: ({focused, size}) => (
              <Image source={AppIcon[item]} style={{width: 24, height: 24}} />
            ),
          }}
        />
      ))}
    </Drawer.Navigator>
  );
}
