import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import * as React from 'react';

import HomeScreen from '../screens/home';
import OnLeave from '../screens/onleave';
import ConfirmDateScreen from '../screens/confirm_date';
import {APP_NAVIGATE_SCREEN} from '../utils/constant';
import {fonts} from '../assets/fonts/fonts';

const {ON_LEAVE, OVERTIME, MAIN, CONFIRM_DATE} = APP_NAVIGATE_SCREEN;

const AppScreen = {
  [MAIN]: HomeScreen,
  [ON_LEAVE]: OnLeave,
  //   [OVERTIME]: Overtime,
  [CONFIRM_DATE]: ConfirmDateScreen,
};
const Tab = createMaterialTopTabNavigator();

export default function TopTabNavigation() {
  return (
    <Tab.Navigator screenOptions={{swipeEnabled: false}}>
      {Object.keys(AppScreen).map((item, index) => (
        <Tab.Screen
          key={index}
          name={item}
          component={AppScreen[item]}
          options={{
            tabBarActiveTintColor: '#3947e9', // tab text color
            scrollEnabled: false,
            upperCaseLabel: false,
            tabBarLabelStyle: {
              fontSize: 9,
              fontFamily: fonts.beProMedium,
            },
          }}
        />
      ))}
    </Tab.Navigator>
  );
}
