/* eslint-disable no-dupe-keys */
import ApiClient from '../axios';
import ApiUrl from '../api/apiUrl';
export default {
  requestGetMyInfo: () => ApiClient.get(ApiUrl.GET_USER_INFO),
  requestGetUserInfoById: userId =>
    ApiClient.get(ApiUrl.GET_INFO + `/${userId}`),

  requestPostLeave: payload => ApiClient.post(ApiUrl.POST_LEAVES_DAY, payload),
  requestGetRandomQuotation: () => ApiClient.get(ApiUrl.GET_RANDOM_QUOTATION),
  requestGetBirthdayUser: (mm, yy) =>
    ApiClient.get(ApiUrl.GET_BIRTHDAY_USER + '?year=' + yy + '&month=' + mm),

  requestPostOTVoucher: payload =>
    ApiClient.post(ApiUrl.POST_OT_VOUCHER, payload),
  requestPostApproveOTVoucher: payload =>
    ApiClient.post(
      ApiUrl.POST_OT_VOUCHER + `/${payload.OtId}/approve`,
      payload.body,
    ),
  requestPostRejectOTVoucher: (otId, comment) =>
    ApiClient.post(
      ApiUrl.POST_OT_VOUCHER + `/${otId}/reject?comment=${comment}`,
    ),
  requestGetOtVoucher: (filter, sort, page, pageSize) =>
    ApiClient.get(
      ApiUrl.GET_OT_VOUCHER +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestDeleteOtVoucher: otId =>
    ApiClient.delete(ApiUrl.DELETE_OT_VOUCHER + `/${otId}`),
  requestGetOtVoucherStatisticChart: () =>
    ApiClient.get(ApiUrl.GET_OT_VOUCHER + '/currentYear/statistic'),
  requestGetOtVoucherById: OTId => ApiClient.get('overtimes/' + OTId),
  requestGetOTHistoriesByID: OTId =>
    ApiClient.get('overtimes/' + OTId + '/histories'),
  requestGetLatestOtVoucher: () =>
    ApiClient.get(ApiUrl.GET_OT_VOUCHER + '?Filters=&Sorts=&Page=1&PageSize=5'),
  requestGetOtApproveVoucherList: (filter, sort, page, pageSize) =>
    ApiClient.get(
      ApiUrl.GET_OT_VOUCHER_PENDING +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetOtVoucherPending: () =>
    ApiClient.get(
      ApiUrl.GET_OT_VOUCHER_PENDING +
        '?Filters=extend_approved_status_name%3D%3DPENDING&Sorts=created_at&Page=1&PageSize=5',
    ),

  requestGetMyDirectManagers: () => ApiClient.get(ApiUrl.GET_MY_DIRECT_MANAGER),
  requestGetMyManagers: () => ApiClient.get(ApiUrl.GET_MY_MANAGERs),
  requestGetPersonnel: () =>
    ApiClient.get(
      ApiUrl.PERSONNEL + `?Filters=disabled==false&Sorts=&Page=1&PageSize=10`,
    ),
  requestGetBankAccount: staff_id =>
    ApiClient.get('users/' + staff_id + '/' + ApiUrl.GET_SALARY_USER),
  requestGetSheet: staff_id => ApiClient.get(ApiUrl.GET_SHEET_ID),

  requestGetLeavesDay: (filter, sort, page, pageSize) =>
    ApiClient.get(
      ApiUrl.LEAVES_DAY +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetLeavesDayById: id =>
    ApiClient.get(ApiUrl.GET_LEAVES_DAY + `/${id}`),

  requestGetRestDay: () => ApiClient.get(ApiUrl.REST_DAY),
  requestGetLatestLeavesDay: () =>
    ApiClient.get(ApiUrl.LEAVES_DAY + '?Filters=&Sorts=&Page=1&PageSize=1'),
  requestGetLeavesDayPending: (filter, sort, page, pageSize) =>
    ApiClient.get(
      ApiUrl.LEAVES_DAY_PENDING +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetLeaveDayApproveReq: (filter, sort, page, pageSize) =>
    ApiClient.get(
      ApiUrl.LEAVES_DAY_APPROVE_REQ +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetLeaveCategories: () => ApiClient.get(ApiUrl.LEAVES_CATEGORY),
  requestDeleteLeaveTicket: id =>
    ApiClient.delete(ApiUrl.DELETE_LEAVE_TICKET + `/${id}`),

  requestPostImage: payload => ApiClient.post(ApiUrl.UPLOAD_IMAGE, payload),
  requestGetImageList: OTId =>
    ApiClient.get(`${ApiUrl.GET_LIST_IMAGE}/` + OTId),

  requestPostUpload: (id, payload) =>
    ApiClient.put(ApiUrl.UPLOAD_IMAGE + `/${id}/upload`, payload),
  requestPostPublicUpload: (id, payload) =>
    ApiClient.put(ApiUrl.UPLOAD_IMAGE + `/${id}/public/upload`, payload),

  requestGetConfirmDay: (page, pageSize) =>
    ApiClient.get(ApiUrl.CONFIRM_DAY + `?Page=${page}&PageSize=${pageSize}`),
  requestGetApproveConfirmDay: (filter, sort, page, pageSize) =>
    ApiClient.get(
      ApiUrl.APPROVE_CONFIRM_DAY +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestGetAbsentChart: () => ApiClient.get(ApiUrl.ABSENT_CHART),
  requestPostConfirmDay: payload =>
    ApiClient.post(ApiUrl.POST_CONFIRM_DAY, payload),
  requestGetConfirmDayHistories: id =>
    ApiClient.get(ApiUrl.POST_CONFIRM_DAY + `/${id}/histories`),
  requestPostConfirmApprove: (id, comment, nextApproverId) =>
    ApiClient.post(
      ApiUrl.POST_CONFIRM_DAY +
        `/${id}/approve?comment=` +
        comment +
        '&nextApproverId=' +
        nextApproverId,
    ),
  requestDeleteConfirmApprove: id =>
    ApiClient.delete(ApiUrl.DELETE_RQ_CONFIRM_DAY + `/${id}`),
  requestPostRejectApprove: (id, comment) =>
    ApiClient.post(
      ApiUrl.POST_CONFIRM_DAY + `/${id}/reject?comment=` + comment,
    ),

  requestChangeAvatar: (id, payload) =>
    ApiClient.put(ApiUrl.CHANGE_AVATAR + `/${id}/uploadAvatar`, payload),
  requestChangeCoverAvatar: (id, payload) =>
    ApiClient.put(ApiUrl.CHANGE_AVATAR + `/${id}/uploadCoverImage`, payload),
  requestChangeInfo: (id, payload) =>
    ApiClient.put(ApiUrl.CHANGE_INFO + `/${id}`, payload),

  // Salary user
  requestGetSaBook: () => ApiClient.get(ApiUrl.SA_BOOK),
  requestGetUserSaSheet: currentSaSheetId =>
    ApiClient.get(
      ApiUrl.MY_SA_SHEETS + `?currentSaSheetId=${currentSaSheetId}`,
    ),
  requestGetUserPayslipSaBook: currentSaSheetId =>
    ApiClient.get(
      ApiUrl.MY_PAY_SA_BOOK + `?currentSabookId=${currentSaSheetId}`,
    ),
  requestGetSaPayslipSections: sheetId =>
    ApiClient.get(ApiUrl.SA_PAY_SLIP_SECTION + `/${sheetId}/saPayslipSections`),
  requestGetSalary: (sectionId, sheetId) =>
    ApiClient.get(
      ApiUrl.SA_TABLE + `/${sectionId}/mySaPayslipItem/data?sheetID=${sheetId}`,
    ),
  requestGetAllowance: (sectionId, sheetId) =>
    ApiClient.get(
      ApiUrl.SA_TABLE + `/${sectionId}/mySaPayslipItem/data?sheetID=${sheetId}`,
    ),

  requestGetTimeSheetProject: () =>
    ApiClient.get(ApiUrl.GET_TIME_SHEET_PROJECT + `/fastData?Page=1`),
  requestGetTimeSheetApproval: (numberWeekOfYear, page, searchQuery) =>
    ApiClient.get(
      ApiUrl.TIME_SHEET_APPROVAL +
        `/2022/${numberWeekOfYear}?Filters=${searchQuery}&Page=${page}&PageSize=10`,
    ),

  requestGetJobName: projectId =>
    ApiClient.get(ApiUrl.GET_TIME_SHEET_PROJECT + `/${projectId}/tasks?Page=1`),
  requestPostSubmitAddJob: (week_id, payload) =>
    ApiClient.put(ApiUrl.SUBMIT_ADD_JOB + `/${week_id}/submit`, payload),
  requestPostAddJob: (year, week, payload) =>
    ApiClient.post(ApiUrl.MY_HR_TIME_SHEET + `/${year}/${week}`, payload),
  requestGetMyTimeSheet: (year, week) =>
    ApiClient.get(ApiUrl.MY_HR_TIME_SHEET + `/${year}/${week}`),
  requestApproveTimeSheet: timeSheetId =>
    ApiClient.put(ApiUrl.HR_TIME_SHEET_WEEK + `/${timeSheetId}/approve`),
  requestRejectTimeSheet: timeSheetId =>
    ApiClient.put(ApiUrl.HR_TIME_SHEET_WEEK + `/${timeSheetId}/reject`),
  requestGetConfirmTimeSheetDetail: (userId, year, numberWeek) =>
    ApiClient.get(
      ApiUrl.CONFIRM_TIME_SHEET_DETAIL + `/${userId}/${year}/${numberWeek}`,
    ),

  requestPostComment: payload => ApiClient.post(ApiUrl.POST_COMMENT, payload),
  requestGetComment: OtId =>
    ApiClient.get(
      ApiUrl.GET_COMMENT + `/${OtId}?Sorts=-created_at&Page=1&PageSize=100`,
    ),
  requestPostCommentLike: commentId =>
    ApiClient.post(ApiUrl.POST_COMMENT + `/${commentId}/likes`),
  requestPostAttachmentComment: (commentId, payload) =>
    ApiClient.post(ApiUrl.POST_COMMENT + `/${commentId}/attachments`, payload),
  //comment
  requestGetCommentByCode: code =>
    ApiClient.get(ApiUrl.POST_COMMENT + `/${code}/fastData`),
  requestPostComment: payload => ApiClient.post(ApiUrl.POST_COMMENT, payload),
  requestGetLeaveHistories: id =>
    ApiClient.get(ApiUrl.POST_LEAVES_DAY + `/${id}/histories`),
  requestPostLeaveApprove: (id, comment, nextApproverId) =>
    ApiClient.post(
      ApiUrl.POST_LEAVES_DAY +
        `/${id}/approve?comment=` +
        comment +
        '&nextApproverId=' +
        nextApproverId,
    ),
  requestPostLeaveReject: (id, comment) =>
    ApiClient.post(ApiUrl.POST_LEAVES_DAY + `/${id}/reject?comment=` + comment),
  requestGetImage: code => ApiClient.get(ApiUrl.UPLOAD_IMAGE + `/${code}`),

  // chấm công
  requestGetTimeKeeping: (filter, page, pageSize, sort) =>
    ApiClient.get(
      ApiUrl.GET_TIME_KEEPING_BY_FILTER +
        `?Filters=${filter}&Sorts=${sort}&Page=${page}&PageSize=${pageSize}`,
    ),
  requestDataChartTimeKeeping: (since, finish) =>
    ApiClient.get(
      ApiUrl.GET_DATA_CHART_TIME_KEEPING +
        `?fromDate=${since}&toDate=${finish}`,
    ),

  // contact information
  requestGetContactUser: userId =>
    ApiClient.get(`users/${userId}/` + ApiUrl.GET_CONTACT_USER),
  requestChangeContactUser: (itemId, payload) =>
    ApiClient.put(ApiUrl.CHANGE_CONTACT_USER + `/${itemId}`, payload),
  requestDeleteContactUser: itemId =>
    ApiClient.delete(ApiUrl.CHANGE_CONTACT_USER + `/${itemId}`),
  requestAddContactUser: (userId, payload) =>
    ApiClient.post(`users/${userId}/` + ApiUrl.ADD_CONTACT_USER, payload),

  requestGetRangeTimeStart: (startDate, userId) =>
    ApiClient.get(
      ApiUrl.POST_LEAVES_DAY +
        `/timeRange/start?startDay=${encodeURIComponent(
          startDate,
        )}&userID=${userId}`,
    ),
  requestGetRangeTimeFinish: (startDate, userId) =>
    ApiClient.get(
      ApiUrl.POST_LEAVES_DAY +
        '/timeRange/finish?startDay=' +
        startDate +
        '&userID=' +
        userId,
    ),
  requestGetNotification: param =>
    ApiClient.get(
      param ? ApiUrl.GET_NOTIFICATION + param : ApiUrl.GET_NOTIFICATION,
    ),
  requestReadNotification: id =>
    ApiClient.put(ApiUrl.GET_NOTIFICATION + `/${id}/read`),
  requestDeleteNotification: id =>
    ApiClient.delete(ApiUrl.GET_NOTIFICATION + `/${id}`),

  requestGetCompanyInfo: () => ApiClient.get(ApiUrl.GET_COMPANY_INFO),

  // notification
  requestSenNotificationByUserId: (approver_id, sender_id, img_path, payload) =>
    ApiClient.post(
      ApiUrl.NOTIFICATION + `/${approver_id}/${sender_id}?img_path=${img_path}`,
      payload,
    ),
};
