import axios from 'axios';
import Utils from '../utils';
import config from '../config';

const axiosFormData = axios.create({
  baseURL: config.apiEndpoint,
  headers: {
    'Content-Type': 'multipart/form-data',
  },
  timeout: config.axiosTimeout,
});

axiosFormData.interceptors.request.use(async configAxios => {
  const auth = await Utils.getData(config.storageKey.AUTH);
  if (auth) {
    configAxios.headers.Authorization = `Bearer ${auth}`;
  }
  return configAxios;
});

axiosFormData.interceptors.response.use(
  response => {
    if (response?.data) {
      return response.data;
    }
    return response;
  },
  error => {
    throw error;
  },
);

export default axiosFormData;
