import React from 'react';
import {Image, SafeAreaView, View} from 'react-native';
import AppText from '../../../components/AppText';
import ButtonComponent from '../../../components/ButtonComponent';
import TextInputComponent from '../../../components/TextInputComponent';
import {BgIntroduce} from '../../../values/images';
import styles from './style';
const ForgotPasswordScreen = ({
  email,
  txtResponse,
  onSubmit,
  goBack,
  isError,
  onChangeText,
}) => {
  return (
    <SafeAreaView style={{flex: 1}}>
      <View style={{flex: 1}}>
        <View style={{flex: 1}}>
          <Image source={BgIntroduce.BgTop} style={[styles.bgFullWidth]} />
        </View>
        <View style={{flex: 3, alignItems: 'center'}}>
          <View style={styles.centerView}>
            <AppText style={styles.txtTitle}>Khôi phục tài khoản</AppText>
            {txtResponse && (
              <AppText style={styles.txtResponse}> {txtResponse}</AppText>
            )}
            <AppText style={{color: 'black', fontWeight: 'bold'}}>
              Email
            </AppText>
            <View>
              {isError.type && (
                <AppText style={{color: 'red', fontSize: 11}}>
                  {isError.text}
                </AppText>
              )}
              <TextInputComponent
                value={email}
                placeholder={'Vui lòng nhập email của bạn'}
                styleAreaInput={{backgroundColor: 'white'}}
                autoCompleteType={'postal-address'}
                keyboardType={'email'}
                onChangeText={onChangeText}
              />
            </View>
            <ButtonComponent
              style={styles.btnSendRequest}
              text={'Gửi yêu cầu'}
              textStyle={{color: 'white'}}
              onPress={onSubmit}
            />
            <ButtonComponent
              style={styles.btnBack}
              text={'Quay lại'}
              textStyle={{color: 'blue'}}
              onPress={goBack}
            />
          </View>
        </View>
        <View style={{flex: 1, justifyContent: 'flex-end'}}>
          <AppText style={{marginLeft: 20}}>2022 @ MeU Solutions, Inc</AppText>
          <Image source={BgIntroduce.BgFtStep1} style={styles.bgFullWidth} />
        </View>
      </View>
    </SafeAreaView>
  );
};

export default ForgotPasswordScreen;
