import React from 'react';
import {useTranslation} from 'react-i18next';
import {
  Dimensions,
  Image,
  SafeAreaView,
  TouchableOpacity,
  View,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import Swiper from 'react-native-swiper';
import AppText from '../../../components/AppText';
import {BgIntroduce, IMAGES} from '../../../values/images';
import string from '../../../values/string';
import styles from './styles';

const windowHeight = Dimensions.get('window').height;

const IntroductionScreen = ({
  indexSwiper,
  showsPagination,
  scroll,
  onSwiper,
  navigateToDomain,
}) => {
  const {t, i18n} = useTranslation();
  return (
    <Swiper
      style={styles.wrapper}
      showsButtons={false}
      loop={false}
      index={indexSwiper}
      showsPagination={showsPagination}
      scrollEnabled={scroll}
      activeDot={
        <View
          style={{
            backgroundColor: '#007aff',
            width: 25,
            height: 8,
            borderRadius: 4,
          }}
        />
      }
      paginationStyle={{
        bottom: windowHeight / 4,
      }}
      onIndexChanged={index => onSwiper(index)}>
      <SafeAreaView style={styles.slide1}>
        <View style={styles.slide1}>
          <Image source={BgIntroduce.BgStep1} style={styles.ImageIntroduce} />
          <Image source={IMAGES.IcLogo} style={{marginVertical: 5}} />
          <LinearGradient
            colors={['#fbc2eb', '#a6c1ee']}
            style={{
              width: 60,
              height: 5,
              marginTop: 10,
              marginBottom: 30,
              borderRadius: 10,
            }}
          />

          {/* <Text style={styles.text}>{string.TITLE_STEP_1}</Text> */}
          <AppText style={styles.text}>{t('Overtime_monitoring')}</AppText>
          <AppText style={styles.subText}>{t('Send_req_OT')}</AppText>
          {/* <TouchableOpacity onPress={nextView} style={[styles.startedBtn, styles.centerBtn]}>
                        <Text style={styles.txtBtn}>{string.GET_STARTED}</Text>
                    </TouchableOpacity> */}
          <Image
            source={BgIntroduce.BgFtStep1}
            style={styles.ImageFooterIntroduce}
          />
        </View>
      </SafeAreaView>
      <SafeAreaView style={styles.slide2}>
        <View style={styles.slide2}>
          <Image source={BgIntroduce.BgStep2} style={styles.ImageIntroduce} />
          <Image source={IMAGES.IcLogo} />
          <LinearGradient
            colors={['#fbc2eb', '#a6c1ee']}
            style={{
              width: 60,
              height: 5,
              marginTop: 15,
              marginBottom: 20,
              borderRadius: 10,
            }}
          />

          <AppText style={styles.text}>{t('Manager_Leave')}</AppText>
          <AppText style={styles.subText}>{t('Track_emp_leave')}</AppText>
          {/* <TouchableOpacity onPress={nextView} style={[styles.centerBtn, styles.noBorderBtn]} title="Next" >
                        <Text style={styles.textPrimary}>{string.NEXT_BUTTON}</Text>
                    </TouchableOpacity> */}
        </View>
      </SafeAreaView>
      <SafeAreaView style={styles.slide3}>
        <View style={styles.slide3}>
          <Image source={BgIntroduce.BgStep3} style={styles.ImageIntroduce} />
          <Image source={IMAGES.IcLogo} />
          <LinearGradient
            colors={['#fbc2eb', '#a6c1ee']}
            style={{
              width: 60,
              height: 5,
              marginTop: 15,
              marginBottom: 20,
              borderRadius: 10,
            }}
          />

          <AppText style={styles.text}>{t('Payroll')}</AppText>
          <AppText style={styles.subText}>{t('Ez_manager_payroll')}</AppText>
          <TouchableOpacity
            onPress={navigateToDomain}
            style={[styles.centerBtn, styles.noBorderBtn]}
            title="Next">
            <AppText style={styles.textPrimary}>{string.NEXT_BUTTON}</AppText>
          </TouchableOpacity>
        </View>
      </SafeAreaView>
    </Swiper>
  );
};

export default IntroductionScreen;
