import React, {useState} from 'react';
import RootNavigation from '../../../navigation/RootNavigation';
import LoginScreen from './LoginScreen';

import {useTranslation} from 'react-i18next';
import OneSignal from 'react-native-onesignal';
import {useDispatch, useSelector} from 'react-redux';
import {loaderSelector} from '../../../app/selectors';
import Utils from '../../../utils';
import {APP_NAVIGATE_SCREEN} from '../../../utils/constant';
import {ToastMessage} from '../../../utils/MessageUtil';
import {authenticate, getMyInfo} from '../authSlice';
const LoginContainer = props => {
  // console.log("props: ", props)
  const dispatch = useDispatch();
  const isLoading = useSelector(loaderSelector);
  const {t, i18n} = useTranslation();

  const [showPass, setShowPass] = useState(true);
  const [userAccount, setUserAccount] = useState({
    username: '',
    password: '',
  });
  const navigateToServer = () => {
    RootNavigation.navigate(APP_NAVIGATE_SCREEN.SERVER);
  };
  const handleUserName = text => {
    if (text != null) {
      setUserAccount({username: text, password: userAccount.password});
    }
  };
  const handlePassword = text => {
    if (text != null) {
      setUserAccount({username: userAccount.username, password: text});
    }
  };
  const hasErrors = () => {
    return !userAccount.username.includes('@');
  };

  const handleSetAccount = () => {
    if (
      userAccount.username.length === 0 ||
      userAccount.password.length === 0
    ) {
      ToastMessage({
        title: 'Hệ thống',
        message: 'Xin vui lòng nhập đầy đủ thông tin !!!',
        type: 'error',
      });
      return true;
    }
    return false;
  };

  const handleLogin = async () => {
    try {
      if (handleSetAccount()) return;

      dispatch(
        authenticate({
          username: userAccount.username,
          password: userAccount.password,
        }),
      ).then(response => {
        const {success} = Utils.getValues(response, 'payload', false);
        dispatch(getMyInfo());
        if (success) {
          ToastMessage({
            title: 'Hệ thống',
            message: 'Đăng nhập thành công',
            type: 'success',
          });
          RootNavigation.navigate(APP_NAVIGATE_SCREEN.MAIN);
        } else {
          ToastMessage({
            title: 'Hệ thống',
            message: 'Tài khoản và mật khẩu không đúng',
            type: 'error',
          });
        }
      });
    } catch (e) {
      console.log('error login: ', e);
      ToastMessage({
        title: 'Hệ thống',
        message: e.toString(),
        type: 'error',
      });
    }
  };

  const sendExternalId = async () => {
    const res = await dispatch(getMyInfo());
    OneSignal.setExternalUserId(res.user.id, results => {
      // The results will contain push and email success statuses
      // console.log('Results of setting external user id');
      console.log('setExternalUser', results);
    });
  };
  const loginProps = {
    isLoading,
    showPass,
    handleLogin,
    setShowPass,
    userAccount,
    handleUserName,
    handlePassword,
    navigateToServer,
  };
  return <LoginScreen {...loginProps} />;
};

export default LoginContainer;
