import React from 'react';
import {useTranslation} from 'react-i18next';
import {Image, SafeAreaView, View} from 'react-native';
import AppText from '../../../components/AppText';
import ButtonComponent from '../../../components/ButtonComponent';
import LoadingProgress from '../../../components/LoadingProgress';
import TextInputComponent from '../../../components/TextInputComponent';
import RootNavigation from '../../../navigation/RootNavigation';
import {APP_NAVIGATE_SCREEN} from '../../../utils/constant';
import colors from '../../../values/colors';
import {BgIntroduce, IMAGES} from '../../../values/images';
import styles from './styles';

const LoginScreen = ({
  isLoading,
  showPass,
  navigateToServer,
  handleLogin,
  setShowPass,
  userAccount,
  handleUserName,
  handlePassword,
}) => {
  const {t, i18n} = useTranslation();
  return (
    <SafeAreaView style={styles.slide5}>
      <View style={styles.slide5}>
        <View style={{flex: 1}}>
          <Image source={BgIntroduce.BgTop} style={[styles.bgFullWidth]} />
        </View>
        <View style={[styles.loginContainer, {flex: 4, alignItems: 'center'}]}>
          <View style={styles.viewLogin}>
            <AppText style={[styles.textTitleHeader, styles.textBlue]}>
              {t('Login')}
            </AppText>
            <AppText style={{color: 'black'}}>{t('Email')}</AppText>
            <TextInputComponent
              styleAreaInput={{backgroundColor: colors.white}}
              placeholder={t('Enter_your_email')}
              keyboardType={'email-address'}
              onChangeText={handleUserName}
              value={userAccount.username}
              leftIcon={IMAGES.IcMail}
            />
            <AppText style={{color: 'black'}}>{t('Password')}</AppText>
            <TextInputComponent
              styleAreaInput={{backgroundColor: colors.white}}
              placeholder={t('Enter_your_password')}
              onChangeText={handlePassword}
              value={userAccount.password}
              rightIcon={showPass ? IMAGES.IcVisibleEye : IMAGES.IcHideEye}
              onPressRightIcon={() => {
                setShowPass(!showPass);
              }}
              secureTextEntry={showPass}
              leftIcon={IMAGES.IcLock}
            />
            <AppText
              style={styles.forgetPassword}
              onPress={() => {
                RootNavigation.navigate(APP_NAVIGATE_SCREEN.FORGOT_PASS);
              }}>
              {t('Forgot_password')}
            </AppText>
            <ButtonComponent
              style={[
                styles.loginScreenBtn,
                {backgroundColor: colors.primary_blue},
              ]}
              text={t('Login')}
              textStyle={{color: colors.white, fontWeight: 'bold'}}
              onPress={handleLogin}
              backgroundColor={colors.white}
              bordered={true}
            />
            <ButtonComponent
              style={[styles.loginScreenBtn, {marginBottom: 20}]}
              text={t('Back')}
              textStyle={{color: colors.primary_blue, fontWeight: 'bold'}}
              onPress={navigateToServer}
            />
          </View>
        </View>
        <View style={{flex: 1, justifyContent: 'flex-end'}}>
          <AppText style={{marginLeft: 20}}>2022 @ MeU Solutions, Inc</AppText>
          <Image source={BgIntroduce.BgFtStep1} style={styles.bgFullWidth} />
        </View>
        {isLoading && <LoadingProgress />}
      </View>
    </SafeAreaView>
  );
};

export default LoginScreen;
