import React, {useEffect} from 'react';
import Splash from 'react-native-splash-screen';

import RootNavigation from '../../../navigation/RootNavigation';
// import { getUserInfo } from '../../../store/actions/userAction'
import AsyncStorage from '@react-native-async-storage/async-storage';
import {useTranslation} from 'react-i18next';
import {useDispatch} from 'react-redux';
import config from '../../../config';
import Utils from '../../../utils';
import AsyncStorageKeys from '../../../utils/AsyncStorageKeys';
import {APP_NAVIGATE_SCREEN} from '../../../utils/constant';
import {getMyInfo} from '../authSlice';
import SplashScreen from './SplashScreen';
const SplashContainer = () => {
  const dispatch = useDispatch();
  const {t, i18n} = useTranslation();
  const checkAccount = async () => {
    const token = await Utils.getData(config.storageKey.AUTH);
    const language = await AsyncStorage.getItem(AsyncStorageKeys.Language);
    i18n.changeLanguage(language);
    if (token) {
      RootNavigation.replace(APP_NAVIGATE_SCREEN.MAIN);
      dispatch(getMyInfo());
    } else {
      RootNavigation.replace(APP_NAVIGATE_SCREEN.INTRO);
    }
  };

  useEffect(() => {
    setTimeout(checkAccount, 4000);
    Splash.hide();
  }, []);

  return <SplashScreen />;
};

export default SplashContainer;
