import React, {useState} from 'react';
import ChatAssistantMainView from './template/ChatAssistantMainView';
const ChatAssistantContainer = () => {
  const [messages, setMessages] = useState([
    {
      id: '1',
      text: 'Hi, is this laptop still in stock? I wanna buy it',
      user: 'user',
    },
  ]);
  const [inputText, setInputText] = useState('');

  const sendMessage = () => {
    if (inputText.trim()) {
      const newMessage = {
        id: String(messages.length + 1),
        text: inputText,
        user: 'user',
      };
      setMessages([...messages, newMessage]);
      setInputText('');

      // Phản hồi giả lập từ trợ lý (có thể thay bằng API thực tế)
      setTimeout(() => {
        const assistantReply = {
          id: String(messages.length + 2),
          text: 'Got it! I’ll process your request. Anything else I can help with? :)',
          user: 'assistant',
        };
        setMessages(prevMessages => [...prevMessages, assistantReply]);
      }, 1000); // Trễ 1 giây để mô phỏng phản hồi
    }
  };
  const chatProps = {
    messages,
    inputText,
    setInputText,
    sendMessage,
  };
  return <ChatAssistantMainView {...chatProps} />;
};

export default ChatAssistantContainer;
