import LottieView from 'lottie-react-native';
import React from 'react';
import {
  FlatList,
  SafeAreaView,
  TextInput,
  TouchableOpacity,
  View,
} from 'react-native';
import VirtualAssistant from '../../../mockup/assistant.json';
import styles from '../styles';
import {ArrowLeftPrimarySVG, SendMessageSVG} from '../../../assets/svg';
import AppText from '../../../components/AppText';
const ChatAssistantMainView = props => {
  const {messages, inputText, setInputText, sendMessage} = props;

  const renderMessage = ({item}) => (
    <View
      style={[
        styles.messageContainer,
        item.user === 'user' ? styles.userMessage : styles.assistantMessage,
      ]}>
      <AppText style={styles.messageText}>{item.text}</AppText>
    </View>
  );

  return (
    <SafeAreaView style={styles.container}>
      <TouchableOpacity style={styles.btnAssistant}>
        <LottieView
          source={VirtualAssistant} // File Lottie của bạn
          style={styles.assistant}
          loop={true}
          autoPlay
          duration={5000}
        />
      </TouchableOpacity>
      {/* Header */}
      <View style={styles.header}>
        <TouchableOpacity style={styles.backButton}>
          <ArrowLeftPrimarySVG width={20} height={20} />
        </TouchableOpacity>
        <View style={styles.headerContent}>
          <AppText style={styles.headerTitle}>Trợ Lý ảo Long Long</AppText>
          <AppText style={styles.headerSubtitle}>Active now</AppText>
        </View>
      </View>

      {/* Danh sách tin nhắn */}
      <FlatList
        data={messages}
        renderItem={renderMessage}
        keyExtractor={item => item.id}
        style={styles.messageList}
        // Đảo ngược danh sách để tin nhắn mới nhất ở dưới
      />

      {/* Ô nhập tin nhắn */}
      <View style={styles.inputContainer}>
        <TextInput
          style={styles.input}
          value={inputText}
          onChangeText={setInputText}
          placeholder="Type something..."
          placeholderTextColor="#999"
        />
        <TouchableOpacity onPress={sendMessage} style={styles.sendButton}>
          <SendMessageSVG width={20} height={20} />
        </TouchableOpacity>
      </View>
    </SafeAreaView>
  );
};

export default ChatAssistantMainView;
