import {createAsyncThunk, createSlice} from '@reduxjs/toolkit';

import serviceRequest from '../../app/serviceRequest';

import confirmDateAPI from '../../api/confirmDateAPI';

import Utils from '../../utils';

const initialState = {
  confirmApprovedDateList: [],
  myAbsentRequests: [],
};

export const getUserConfirmDay = createAsyncThunk(
  'confirmDate/getUserConfirmDay',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: confirmDateAPI.requestGetConfirmDay,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getConfirmApprovedDate = createAsyncThunk(
  'confirmDate/getConfirmApprovedDate',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: confirmDateAPI.requestGetConfirmApprovedDate,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getMyAbsentRequests = createAsyncThunk(
  'confirmDate/getMyAbsentRequests',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: confirmDateAPI.requestMyAbsentRequest,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getAbsentChart = createAsyncThunk(
  'confirmDate/getAbsentChart',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: confirmDateAPI.requestGetAbsentChart,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const postConfirmWorkingDay = createAsyncThunk(
  'confirmDate/postConfirmWorkingDay',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: confirmDateAPI.requestPostConfirmWorkingDay,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const postSubmitApproveConfirmWorkingDayRequest = createAsyncThunk(
  'confirmDate/postSubmitApproveConfirmWorkingDayRequest',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: confirmDateAPI.requestPostApproveConfirmWorkingDay,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
const authSlice = createSlice({
  name: 'confirmDate',
  initialState: initialState,
  reducers: {},
  extraReducers: builder => {
    builder.addCase(getUserConfirmDay.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.confirmDateList = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
    builder.addCase(getConfirmApprovedDate.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.confirmApprovedDateList = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
    builder.addCase(getMyAbsentRequests.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      
      if (success) {
        state.myAbsentRequests = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
  },
});

const {reducer, actions} = authSlice;
export default reducer;
