import React from 'react';

import {useSelector} from 'react-redux';
import {
  authSelector,
  confirmDateSelector,
  onLeaveSelector,
} from '../../app/selectors';
import ConfirmDateContainer from './ConfirmDateContainer';

export default function ConfirmDateScreen() {
  const authSelect = useSelector(authSelector);
  const confirmDateSelect = useSelector(confirmDateSelector);
  const onLeaveSelect = useSelector(onLeaveSelector);

  const {directManagersList = []} = onLeaveSelect;
  const {userInfo} = authSelect;
  const {confirmDateList, confirmApprovedDateList, myAbsentRequests} =
    confirmDateSelect;
  const confirmScreenProps = {
    userInfo,
    confirmDateList,
    confirmApprovedDateList,
    directManagersList,
    myAbsentRequests,
  };
  return <ConfirmDateContainer {...confirmScreenProps} />;
}
