import {Dimensions, StyleSheet} from 'react-native';
import dimension from '../../values/dimension';
import colors from '../../values/colors';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('window').height;
const styles = StyleSheet.create({
  container: {
    flex: 1,
  },
  pieChartContainer: {
    flexDirection: 'row',
  },
  pieChartView: {
    borderWidth: 1,
    borderColor: 'white',
    borderRadius: 5,
    backgroundColor: 'white',
    marginTop: 10,
    flexDirection: 'row',
    marginLeft: 10,
    marginRight: 10,
    padding: 10,
  },
  pieItem: {
    alignItems: 'center',
  },
  pieFill: {
    position: 'absolute',
    width: 100,
    height: 200,
    alignItems: 'center',
    justifyContent: 'center',
  },
  pieFillTextAmount: {
    fontSize: 15,
    color: '#757575',
  },
  pieFillText: {
    fontSize: 10,
    lineHeight: 15,
  },
  boldTitle: {
    fontWeight: '500',
    marginBottom: 10,
    fontSize: 14,
    color: 'black',
    marginLeft: 10,
  },
  h2: {
    fontWeight: '500',
    fontSize: 20,
    color: 'black',
  },
  viewTextPie: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  bgLeftViewTextPie: {
    width: 10,
    height: 10,
  },
  bgRightViewTextPie: {
    backgroundColor: '#0abb87',
    width: 10,
    height: 10,
    marginRight: 5,
  },
  view: {
    width: windowWidth - 20,
    backgroundColor: colors.white,
    borderColor: colors.white,
    padding: 10,
    marginHorizontal: 10,
    borderRadius: 5,
  },
  btnConfirm: {
    backgroundColor: colors.purple_blue,
    borderRadius: 5,
    flexDirection: 'row',
    padding: 10,
  },
  whiteTxt: {
    color: colors.white,
    fontWeight: '500',
  },
  blueTxt: {
    color: colors.purple_blue,
    fontWeight: '500',
  },
  iconPlus: {
    width: 20,
    height: 20,
    marginRight: 5,
  },
  primary_blue: {
    color: colors.purple_blue,
  },
  item: {
    padding: 10,
    margin: 8,
    borderWidth: 1,
    borderBottomColor: colors.gray95,
    borderTopColor: colors.gray95,
    borderRightColor: colors.gray95,
    borderTopLeftRadius: 10,
    borderBottomLeftRadius: 10,
    borderLeftWidth: 5,
    flexDirection: 'row',
  },
  title: {
    fontWeight: '500',
    fontSize: 14,
    color: 'black',
  },
  centeredView: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 22,
  },
  modalView: {
    backgroundColor: colors.white,
    borderRadius: 20,
    padding: 10,
    shadowColor: colors.black1,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
    marginTop: 80,
    height: windowHeight,
    width: '100%',
  },
  button: {
    borderRadius: 20,
    padding: 10,
    elevation: 2,
  },
  buttonOpen: {
    backgroundColor: '#F194FF',
  },
  buttonClose: {
    backgroundColor: '#2196F3',
  },
  textStyle: {
    color: 'white',
    fontWeight: 'bold',
    textAlign: 'center',
  },
  modalTitle: {
    fontWeight: '800',
    fontSize: 16,
  },
  dropdown1DropdownStyle: {backgroundColor: '#EFEFEF'},
  dropdown1RowStyle: {
    backgroundColor: '#EFEFEF',
    borderBottomColor: '#C5C5C5',
    height: 38,
    borderRadius: 4,
  },
  dropdown1RowTxtStyle: {color: '#444', textAlign: 'left', fontSize: 14},
  dropdownSelectTimeText: {color: '#444', textAlign: 'left', fontSize: 14},
  dropdown1BtnStyle: {
    backgroundColor: '#FFF',
    borderWidth: 0.5,
    borderRadius: 8,
    height: 35,
    width: 130,
    fontSize: 12,
    borderColor: '#444',
    zIndex: 100,
  },
  dropdown1BtnTxtStyle: {color: '#000', fontSize: 14, textAlign: 'center'},
  rowView: {
    flexDirection: 'row',
    marginTop: 10,
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  inputText: {
    backgroundColor: colors.white,
    width: 200,
  },
  touchableOpacity: {
    borderColor: colors.primary_blue,
    borderStyle: 'dotted',
    borderWidth: 2,
    justifyContent: 'center',
    alignItems: 'center',
    height: 50,
    padding: 10,
    width: 50,
  },
  btnSubmit: {
    backgroundColor: colors.purple_blue,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    paddingHorizontal: 10,
  },
  btnCancel: {
    backgroundColor: colors.white,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  ImgAvatar: {
    width: 50,
    height: 50,
    borderRadius: 30,
  },
  imgUpload: {
    resizeMode: 'contain',
    height: 80,
    width: 80,
  },
  //modal detail
  modalViewEdit: {
    backgroundColor: 'white',
    borderRadius: 20,
    padding: 16,
    height: windowHeight,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
    marginTop: 20,
  },
  headerModalBottom: {
    paddingRight: 10,
    paddingLeft: 10,
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  titleModalBottom: {
    fontSize: 16,
    fontWeight: '500',
  },
  bodyHeight: {
    height: '88%',
    marginBottom: 10,
  },
  bodyHeightCreate: {
    height: '75%',
  },
  bodyModal: {
    flex: 1,
    paddingHorizontal: 10,
    marginTop: 16,
  },
  commonDetail: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    fontSize: 14,
    marginBottom: 12,
    fontFamily: 'Roboto',
  },
  attachment: {
    borderColor: '#c4c4c4',
    borderStyle: 'dashed',
    borderWidth: 0.5,
    borderRadius: 4,
    height: 60,
    width: '50%',
    justifyContent: 'center',
    alignItems: 'center',
  },
  checkbox: {
    alignSelf: 'center',
    height: 16,
    width: 16,
    marginRight: 4,
  },
  commentHistories: {
    flexDirection: 'row',
    marginBottom: 10,
  },
  textMediumGrey: {
    color: '#757575',
  },
  avatarApprove: {
    width: 32,
    height: 32,
    borderRadius: 4,
  },
  avatarComment: {
    width: 32,
    height: 32,
    borderRadius: 32,
  },
  commentBox: {
    backgroundColor: '#e5eaf0',
    width: '88%',
    marginLeft: 8,
    paddingHorizontal: 12,
    paddingVertical: 8,
    borderTopRightRadius: 4,
    borderBottomRightRadius: 4,
    borderBottomLeftRadius: 4,
  },
  commentText: {
    marginLeft: 8,
    width: '100%',
    color: '#959595',
    fontSize: 12,
    borderBottomColor: '#5c65dc',
    borderBottomWidth: 1,
    paddingLeft: 8,
    paddingRight: 28,
    paddingVertical: 10,
  },
  bottomModal: {
    height: 50,
    width: '100%',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 8,
  },
  wrapperComment: {
    borderColor: colors.purple_blue,
    borderStyle: 'dashed',
    borderWidth: 0.5,
    borderRadius: 4,
    height: 60,
    width: '81%',
    padding: 8,
  },
  commentInput: {
    fontSize: 13,
  },
  btnAccept: {
    flexDirection: 'row',
    paddingHorizontal: 8,
    paddingVertical: 12,
    backgroundColor: colors.purple_blue,
    borderRadius: 4,
  },
  btnReject: {
    flexDirection: 'row',
    paddingHorizontal: 8,
    paddingVertical: 12,
    marginRight: 8,
  },
  btnClose: {
    width: 20,
    height: 20,
    position: 'absolute',
    top: -10,
    right: 0,
  },
  txtDate: {marginRight: 5, color: 'black', fontWeight: '500', fontSize: 12},
  cell: {
    width: 30,
    height: 30,
    marginRight: 5,
    justifyContent: 'center',
    alignItems: 'center',
  },
  viewDayOfWeek: {
    flexDirection: 'row',
    width: 240,
    justifyContent: 'space-between',
    alignItems: 'center',
    borderBottomWidth: 1,
    borderBottomColor: colors.purple_blue,
    paddingBottom: 5,
    paddingLeft: 10,
    paddingRight: 15,
  },
  viewCalendar: {
    flexWrap: 'wrap',
    flexDirection: 'row',
    width: 240,
    borderWidth: 1,
    borderRadius: 8,
    borderColor: '#7d93ff',
    paddingTop: 15,
  },
  refreshBtn: {
    justifyContent: 'center',
    alignItems: 'center',
    padding: 10,
    flexDirection: 'row',
  },
  emptyConfirmWorkingDays: {
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: colors.white,
    marginTop: 10,
    padding: 20,
  },
});
export const statisticsConfirmWorkdaysStyles = StyleSheet.create({
  container: {
    padding: 15,
    backgroundColor: 'white',
    height: 380,
    margin: 10,
    borderRadius: 5,
  },
});
export const modalRequestConfirmWorkdaysStyles = StyleSheet.create({
  avatarUser: {
    width: 50,
    height: 50,
    borderRadius: 30,
  },
  btnCancel: {
    backgroundColor: colors.white,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  rowView: {
    flexDirection: 'row',
    marginTop: 10,
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  addConfirmDateRequestImageBtn: {
    borderColor: colors.primary_blue,
    borderStyle: 'dotted',
    borderWidth: 2,
    justifyContent: 'center',
    alignItems: 'center',
    height: 50,
    padding: 10,
    width: 50,
  },
  chooseTimeSection: {
    alignItems: 'flex-end',
    flexDirection: 'row',
    justifyContent: 'space-between',
    borderBottomWidth: 0.5,
    height: 35,
    width: 200,
    borderColor: colors.grey444,
  },
});
export default styles;
