import Moment from 'moment';
import React from 'react';
import {
  Image,
  SafeAreaView,
  ScrollView,
  TouchableOpacity,
  View,
} from 'react-native';
import Alert from 'react-native-awesome-alerts';
import ButtonComponent from '../../../components/ButtonComponent';
import {GifType, IMAGES} from '../../../values/images';
import styles from '../style';

import FastImage from 'react-native-fast-image';
import SelectDropdown from 'react-native-select-dropdown';
import AppText from '../../../components/AppText';
import StatisticsConfirmWorkdays from './components/StatisticsConfirmWorkdays';
import commonStyles from '../../../styles/commonStyles';
import config from '../../../config';
import SelectDropdownComponent from '../../../components/Select';
import Utils from '../../../utils';
import colors from '../../../values/colors';
import ModalRequestConfirmWorkingDays from './subViews/ModalRequestConfirmWorkingDays';

const approveWorkingDayStatus = [
  {label: 'Tất cả', value: 'Tất cả'},
  {label: 'Chưa duyệt', value: 'Chưa duyệt'},
  {label: 'Đã duyệt', value: 'Đã duyệt'},
  {label: 'Đã từ chối', value: 'Đã từ chối'},
];

const ConfirmWorkingDaysSession = React.memo(
  ({onOpenModalRequestConfirmWorkingDays, navigateToDayWage}) => {
    return (
      <View style={[styles.view, commonStyles.baseShadow]}>
        <AppText style={{fontWeight: '500', marginBottom: 10}}>
          Xác nhận ngày công của bạn:
        </AppText>
        <View style={{alignItems: 'center', justifyContent: 'center'}}>
          <ButtonComponent
            style={styles.btnConfirm}
            onPress={() => onOpenModalRequestConfirmWorkingDays()}
            leftIcon={IMAGES.IcBtnAdd}
            styleIcon={styles.iconPlus}
            text={'XÁC NHẬN NGÀY CÔNG'}
            textStyle={styles.whiteTxt}
          />
        </View>
        <AppText style={{fontWeight: '500'}}>Liên kết nhanh: </AppText>
        <TouchableOpacity style={commonStyles.row} onPress={navigateToDayWage}>
          <Image source={IMAGES.IcTask} style={styles.iconPlus} />
          <AppText style={styles.primary_blue}>Bảng chấm công của tôi</AppText>
        </TouchableOpacity>
      </View>
    );
  },
);

const ApproveRequestWorkingDays = React.memo(
  props => {
    const {
      approveReqPayload,
      onChangeSelectFilter,
      requestApproveArr = [],
      onOpenModalRequestConfirmWorkingDays,
    } = props;
    return (
      <View
        style={[
          styles.view,
          commonStyles.baseShadow,
          commonStyles.marginVertical10,
        ]}>
        <View style={[commonStyles.row, commonStyles.spaceBetweenCenter]}>
          <AppText
            style={{
              fontWeight: 'bold',
              fontSize: 17,
            }}>
            Duyệt ngày công
          </AppText>
          <SelectDropdownComponent
            value={approveReqPayload?.type}
            selectData={approveWorkingDayStatus}
            setValue={onChangeSelectFilter}
            width={150}
          />
        </View>

        {requestApproveArr.length > 0 &&
          requestApproveArr.map((item, index) => (
            <TouchableOpacity
              onPress={() => onOpenModalRequestConfirmWorkingDays(item)}
              key={index}
              style={[
                styles.item,
                commonStyles.spaceBetweenCenter,
                {
                  borderLeftColor: item?.extend_approved_status_color,
                },
              ]}>
              <View style={commonStyles.row}>
                <Image
                  source={
                    item?.extend_creator_avatar
                      ? {
                          uri:
                            config.imageEndPoint + item.extend_creator_avatar,
                        }
                      : IMAGES.IcAvatarDefault
                  }
                  style={{width: 35, height: 35, marginRight: 5}}
                />
                <View>
                  <AppText style={styles.title}>
                    {item?.extend_creator_full_name?.length > 20
                      ? item?.extend_creator_full_name.slice(0, 15) + '...'
                      : item?.extend_creator_full_name}
                  </AppText>
                  <AppText isSubText>
                    {Moment(item.start).format('DD/MM/YYYY')}
                  </AppText>
                </View>
              </View>
              <View
                style={{
                  alignItems: 'flex-end',
                }}>
                <AppText>
                  {item.reason.length > 20
                    ? item.reason.slice(0, 15) + '...'
                    : item.reason}
                </AppText>
                <AppText isSubText>
                  {Utils.minutesToHours(item?.start, item?.finish)}
                </AppText>
              </View>
            </TouchableOpacity>
          ))}
        {/* {!isDisableLoadMore.approveRequestBtn &&
          requestApproveArr?.length > 0 && (
            <ButtonComponent
              style={{
                justifyContent: 'center',
                alignItems: 'center',
                padding: 10,
              }}
              text={'Xem thêm'}
              textStyle={{color: '#5d78ff'}}
              onPress={onLoadMoreRequestApprove}
            />
          )} */}
      </View>
    );
  },
  function (prevProps, nextProps) {
    return prevProps.requestApproveArr === nextProps.requestApproveArr;
  },
);
const ConfirmWorkingDays = React.memo(
  ({
    myAbsentRequests,
    onOpenModalRequestConfirmWorkingDays,
    onRefreshConfirmList,
  }) => {
    return (
      <View
        style={[
          styles.view,
          commonStyles.baseShadow,
          commonStyles.marginVertical10,
        ]}>
        <View style={[commonStyles.row, commonStyles.spaceBetweenCenter]}>
          <AppText
            isBold
            style={{
              fontSize: 17,
            }}>
            Xác nhận ngày công của tôi
          </AppText>
          <ButtonComponent
            text={'Tải lại'}
            textStyle={{color: colors.purple_blue}}
            style={styles.refreshBtn}
            onPress={onRefreshConfirmList}
            leftIcon={IMAGES.IcRefresh}
            styleIcon={{width: 20, height: 20}}
          />
        </View>
        {myAbsentRequests.length === 0 ? (
          <View style={styles.emptyConfirmWorkingDays}>
            <AppText style={{textAlign: 'center'}}>
              Chưa có ngày công nào 😢 Bạn vui lòng thêm ngày công ở ngay bên
              trên nhé!
            </AppText>
            <FastImage
              source={GifType.gifConfirm}
              style={{width: '90%', height: 250}}
            />
          </View>
        ) : (
          <>
            {myAbsentRequests.map((item, index) => (
              <TouchableOpacity
                onPress={() => onOpenModalRequestConfirmWorkingDays(item)}
                key={index}
                style={[
                  styles.item,
                  {
                    borderLeftColor: item.extend_approved_status_color,
                  },
                ]}>
                <View>
                  <AppText style={styles.title}>
                    {item.extend_creator_full_name}
                  </AppText>
                  <AppText>{Moment(item.start).format('DD/MM/YYYY')}</AppText>
                </View>
                <View
                  style={{
                    flex: 1,
                    justifyContent: 'flex-end',
                    alignItems: 'flex-end',
                    marginLeft: 10,
                  }}>
                  <AppText>
                    {item.reason.length > 20
                      ? item.reason.slice(0, 15) + '...'
                      : item.reason}
                  </AppText>
                  <AppText>
                    {Utils.minutesToHours(item.start, item.finish)}
                  </AppText>
                </View>
              </TouchableOpacity>
            ))}
          </>
        )}

        {/* {confirmList.length > 0 && !isDisableLoadMore.confirmBtn && (
        <ButtonComponent
          style={{
            justifyContent: 'center',
            alignItems: 'center',
            padding: 10,
          }}
          text={'Xem thêm'}
          textStyle={{color: '#5d78ff'}}
          onPress={onLoadMoreConfirmList}
        />
      )} */}
      </View>
    );
  },
  function (prevProps, nextProps) {
    return prevProps.myAbsentRequests === nextProps.myAbsentRequests;
  },
);
const ConfirmDateMainView = ({
  navigateToDayWage,
  myAbsentRequests = [],
  onRefreshConfirmList,
  onOpenModalRequestConfirmWorkingDays,
  dataChart,
  onChangeMonthFilter,
  dayPress,
  approveRequestWorkingDaysProps,
  modalRequestConfirmWorkingDays,
  modalRequestConfirmWorkingDaysProps,
}) => {
  return (
    <SafeAreaView>
      <ScrollView nestedScrollEnabled={true}>
        <StatisticsConfirmWorkdays
          dataChart={dataChart}
          onChangeMonthFilter={onChangeMonthFilter}
          dayPress={dayPress}
        />
        <ConfirmWorkingDaysSession
          navigateToDayWage={navigateToDayWage}
          onOpenModalRequestConfirmWorkingDays={
            onOpenModalRequestConfirmWorkingDays
          }
        />
        <ApproveRequestWorkingDays {...approveRequestWorkingDaysProps} />
        <ConfirmWorkingDays
          myAbsentRequests={myAbsentRequests}
          onOpenModalRequestConfirmWorkingDays={
            onOpenModalRequestConfirmWorkingDays
          }
          onRefreshConfirmList={onRefreshConfirmList}
        />
      </ScrollView>
      {modalRequestConfirmWorkingDays?.visible && (
        <ModalRequestConfirmWorkingDays
          {...modalRequestConfirmWorkingDaysProps}
        />
      )}
    </SafeAreaView>
  );
};

export default ConfirmDateMainView;
