import Moment from 'moment';
import React, {memo} from 'react';
import {View} from 'react-native';
import styles, {statisticsConfirmWorkdaysStyles} from '../../style';

import AppText from '../../../../components/AppText';
import SelectDropdownComponent from '../../../../components/Select';
import commonStyles from '../../../../styles/commonStyles';

const chartDaysOfWeek = ['T2', 'T3', 'T4', 'T5', 'T6', 'T7', 'CN'];
const typeChartColor = [
  {color: '#7d93ff', name: 'Trên 6h'},
  {color: '#9eaeff', name: '4-6h'},
  {color: '#bec9ff', name: '2-4h'},
  {color: '#dfe4ff', name: '0-2h'},
  {color: '#f2f2f2', name: '0h'},
];
const dayOfWeek = [
  'Monday',
  'Tuesday',
  'Wednesday',
  'Thursday',
  'Friday',
  'Saturday',
  'Sunday',
];
const monthsOfYear = [
  {label: 'Tháng 01', value: 'Tháng 01'},
  {label: 'Tháng 02', value: 'Tháng 02'},
  {label: 'Tháng 03', value: 'Tháng 03'},
  {label: 'Tháng 04', value: 'Tháng 04'},
  {label: 'Tháng 05', value: 'Tháng 05'},
  {label: 'Tháng 06', value: 'Tháng 06'},
  {label: 'Tháng 07', value: 'Tháng 07'},
  {label: 'Tháng 08', value: 'Tháng 08'},
  {label: 'Tháng 09', value: 'Tháng 09'},
  {label: 'Tháng 10', value: 'Tháng 10'},
  {label: 'Tháng 11', value: 'Tháng 11'},
  {label: 'Tháng 12', value: 'Tháng 12'},
];
const StatisticsConfirmWorkdays = React.memo(
  ({dataChart, onChangeMonthFilter, dayPress}) => {
    return (
      <View
        style={[
          statisticsConfirmWorkdaysStyles.container,
          commonStyles.baseShadow,
        ]}>
        <AppText style={[styles.title, {marginBottom: 20}]}>
          Thống kê xác nhận ngày công của tôi
        </AppText>
        <SelectDropdownComponent
          selectData={monthsOfYear}
          width={130}
          setValue={onChangeMonthFilter}
        />
        <View style={{flexDirection: 'row', marginTop: 20}}>
          <View style={styles.viewCalendar}>
            <View style={styles.viewDayOfWeek}>
              {chartDaysOfWeek.map((day, i) => (
                <AppText key={day} style={{fontSize: 12, fontWeight: 'bold'}}>
                  {day}
                </AppText>
              ))}
            </View>
            {dataChart?.data.length > 0 &&
              dataChart?.data?.map((item, index) => {
                let flag = false;
                return (
                  <View key={index}>
                    {(index == 0 && (
                      <View
                        style={{
                          flexDirection: 'row',
                        }}>
                        {dayOfWeek.map((el, i) => {
                          if (flag) return true;
                          if (Moment(item.date).format('dddd') === el) {
                            flag = true;
                            return (
                              <View
                                key={i}
                                style={{
                                  width: 30,
                                  height: 30,
                                  backgroundColor:
                                    (parseInt(item.absent_hours) > 6 &&
                                      '#7d93ff') ||
                                    (parseInt(item.absent_hours) >= 4 &&
                                      parseInt(item.absent_hours) <= 6 &&
                                      '#7d93ff') ||
                                    (parseInt(item.absent_hours) >= 2 &&
                                      parseInt(item.absent_hours) <= 4 &&
                                      '#7d93ff') ||
                                    (parseInt(item.absent_hours) > 0 &&
                                      parseInt(item.absent_hours) <= 2 &&
                                      '#dfe4ff') ||
                                    '#f2f2f2',
                                  justifyContent: 'center',
                                  alignItems: 'center',
                                  margin: 2,
                                }}>
                                {
                                  <AppText>{`${new Date(
                                    item.date,
                                  ).getDate()}`}</AppText>
                                }
                              </View>
                            );
                          } else {
                            return (
                              <View
                                key={i}
                                style={{
                                  width: 30,
                                  height: 30,
                                  backgroundColor: '#f2f2f2',
                                  justifyContent: 'center',
                                  alignItems: 'center',
                                  margin: 2,
                                }}></View>
                            );
                          }
                        })}
                      </View>
                    )) || (
                      <View
                        style={{
                          width: 30,
                          height: 30,
                          backgroundColor:
                            (parseInt(item.absent_hours) > 6 && '#7d93ff') ||
                            (parseInt(item.absent_hours) >= 4 &&
                              parseInt(item.absent_hours) <= 6 &&
                              '#7d93ff') ||
                            (parseInt(item.absent_hours) >= 2 &&
                              parseInt(item.absent_hours) <= 4 &&
                              '#7d93ff') ||
                            (parseInt(item.absent_hours) > 0 &&
                              parseInt(item.absent_hours) <= 2 &&
                              '#dfe4ff') ||
                            '#f2f2f2',
                          justifyContent: 'center',
                          alignItems: 'center',
                          margin: 2,
                        }}>
                        {
                          <AppText>{`${new Date(
                            item.date,
                          ).getDate()}`}</AppText>
                        }
                      </View>
                    )}
                  </View>
                );
              })}
          </View>
          <View style={{marginLeft: 30}}>
            {typeChartColor &&
              typeChartColor.map((item, i) => (
                <View key={i} style={{flexDirection: 'row'}}>
                  <View
                    style={{
                      width: 20,
                      height: 20,
                      marginRight: 10,
                      marginBottom: 2,
                      backgroundColor: item.color,
                    }}
                  />
                  <AppText style={{fontSize: 11}}>{item.name}</AppText>
                </View>
              ))}
            <View style={{marginTop: 10}}>
              {dayPress && <AppText>{dayPress}</AppText>}
            </View>
          </View>
        </View>
      </View>
    );
  },
  function areEquals(prevProps, nextProps) {
    return prevProps.dataChart === nextProps.dataChart;
  },
);

export default memo(StatisticsConfirmWorkdays);
