import Moment from 'moment';
import React, {useCallback, useEffect, useState} from 'react';
import {
  Alert,
  BackHandler,
  Image,
  Linking,
  Platform,
  TouchableOpacity,
  View,
} from 'react-native';
import {launchImageLibrary} from 'react-native-image-picker';
import Swiper from 'react-native-swiper';
import Toast from 'react-native-toast-message';
import {useDispatch} from 'react-redux';
import AppText from '../../components/AppText';
import {
  getBirthDayUserByDate,
  getNotificationOfUser,
  getPersonnel,
  sendNotification,
} from '../../store/actions/UserAction';
import {IMAGES} from '../../values/images';
import ProfileUserComponent from './components/ProfileUserComponent';
import homePropsProvider from './homePropsProvider';
import {
  getBirthDayUser,
  getRadomQuotation,
  getUserDirectManagers,
} from './homeSlice';
import styles from './style';
import HomeMainView from './template/HomeMainView';
import RootNavigation from '../../navigation/RootNavigation';
import config from '../../config';
import {APP_NAVIGATE_SCREEN} from '../../utils/constant';
const HomeContainer = props => {
  const {userInfo, quotationList, birthdayListInMonth, randomQuotation} = props;
  const dispatch = useDispatch();
  const [RemoteComponent, setRemoteComponent] = useState(null);
  const [loading, setLoading] = useState(false);
  const [arrPersonnel, setArrPersonnel] = useState([]);
  const [showModalInstall, setShowModalInstall] = useState(false);
  //console.log('userDetails', userDetails);
  const dataBirthday = [
    {
      id: 0,
      name: 'Tiến Dũng',
      position: 'Phó giám đốc',
    },
    {
      id: 1,
      name: 'Vĩnh Lộc',
      position: 'Trưởng phòng nhân sự',
    },
    {
      id: 2,
      name: 'Phước Vũ',
      position: 'Trường phòng test',
    },
    {
      id: 3,
      name: 'Thanh Bình',
      position: 'Trưởng phòng test',
    },
  ];

  const [openView, setOpenView] = useState([
    {enable: false},
    {enable: false},
    {enable: false},
    {enable: false},
  ]);
  const [bdUserCurrentMonth, setArrBdCurrentMonth] = useState();
  const [birthdayOfUser, setBirthOfUser] = useState();
  //deep link imcheckin
  const supportedURL = 'im-checkin://login_step_2';
  const chPlayLink =
    'https://play.google.com/store/apps/details?id=com.imchecking';
  const appStore = 'https://apps.apple.com/vn/app/imcheckin/id1545100199?l=vi';

  {
    /* modal - item birthdayArr - Image*/
  }
  const [modalVisible, setModalVisible] = useState({
    isVisible: false,
    birthdayArr: null,
    day: '',
    managerOpenWish: [],
  });

  const [openProfileComponent, setOpenProfileComponent] = useState(false);
  {
    /**wish birthday */
  }
  const [wishTxt, setWishTxt] = useState();
  const [wishList, setWishList] = useState([]);

  // main function
  const loadListPersonnel = async () => {
    const res = await dispatch(getPersonnel());
    if (res && res.length > 0) {
      //console.log(res);
      setArrPersonnel(res);
    }
  };

  const handleOpenDesBirthday = useCallback(
    day => {
      const formatDate = `${day.day < 10 ? `0${day.day}` : `${day.day}`}-${
        day.month < 10 ? `0${day.month}` : `${day.month}`
      }-${day.year}`;
      let arrBdUser = [];
      let lengthKey = [];
      for (const [key, value] of Object.entries(birthdayListInMonth)) {
        if (key.includes(formatDate)) {
          arrBdUser.push(...value);
          value.forEach(item => lengthKey.push({enable: false}));
        }
      }
      // console.log("lengthKey", lengthKey)
      setModalVisible({
        isVisible: true,
        birthdayArr: arrBdUser,
        day: day,
        managerOpenWish: lengthKey,
      });
    },
    [birthdayListInMonth],
  );
  const handleCloseDesBirthday = () =>
    setModalVisible({
      isVisible: false,
      birthdayArr: null,
      day: '',
      managerOpenWish: [],
    });
  const OpenURLButton = async () => {
    const supported = await Linking.canOpenURL(supportedURL);

    if (supported) {
      // Opening the link with some app, if the URL scheme is "http" the web link should be opened
      // by some browser in the mobile
      await Linking.openURL(supportedURL);
    } else {
      if (Platform.OS === 'ios') {
        await Linking.openURL(appStore);
      } else {
        await Linking.openURL(chPlayLink);
      }
    }
  };
  const openModalHappyBirthday = index => {
    //console.log("item", index)
    let newState = [...openView];
    newState[index].enable = true;
    setOpenView(newState);
    //setOpenView(state => ({ ...state, [openView[index].enable]: true }))
  };
  const closeModalHappyBirthday = index => {
    let newState = [...openView];
    newState[index].enable = false;
    setOpenView(newState);
  };
  const openModalWishBirthday = index => {
    //console.log("item", index)
    let managerOpenWish = [...modalVisible.managerOpenWish];
    managerOpenWish[index].enable = true;
    setModalVisible(prev => ({...prev, managerOpenWish}));
    // console.log("clone", clone)
  };
  const closeModalWishBirthday = index => {
    let managerOpenWish = [...modalVisible.managerOpenWish];
    managerOpenWish[index].enable = false;
    setModalVisible(prev => ({...prev, managerOpenWish}));
  };
  const sendWishBirthday = async (approver, index) => {
    //console.log('user', user);

    if (!wishTxt) {
      return;
    }
    const {imgArr} = modalVisible.birthdayArr[0];
    //console.log('imgArr', imgArr);
    const res = await dispatch(
      sendNotification(
        approver.id,
        userInfo.id,
        imgArr,
        'Lời chúc sinh nhật',
        wishTxt,
        208,
        'sinh nhật',
      ),
    );
    if (res) {
      setWishTxt();
      closeModalWishBirthday(index);
      Toast.show({
        type: 'success',
        text1: `Hệ thống`,
        text2: `Gửi lời chúc thành công`,
        style: {zIndex: 1001},
        visibilityTime: 2000,
      });
    }
  };
  const loadWishUser = async () => {
    const arrNoti = await dispatch(
      getNotificationOfUser(
        `?Filters=${encodeURIComponent(
          `created_at>=${Moment()
            .startOf('year')
            .format('YYYY-MM-DD')},sub_category_type==208`,
        )}`,
      ),
    );

    //console.log('arrNoti', arrNoti);
    if (arrNoti) {
      setWishList(arrNoti);
    }
  };
  const formatDateList = async () => {
    if (birthdayListInMonth) {
      var size = Object.keys(birthdayListInMonth).length;
      const today = new Date();
      const formatToday = Moment(today).format('DD-MM-YYYY');
      // console.log(formatToday)
      // console.log('size', size)
      if (size >= 1) {
        let lstBdUser = [];
        for (const [key, value] of Object.entries(birthdayListInMonth)) {
          if (value.length > 0) {
            //console.log("key", value)
            if ([key].length > 0) {
              const formatToday = [key];
              const arr = formatToday[0].split('-');
              const res = arr[2] + '-' + arr[1] + '-' + arr[0];
              // console.log('formatToday', arr[2] + '-' + arr[1] + '-' + arr[0])
              lstBdUser.push({
                [res]: {marked: true, dotColor: 'red', activeOpacity: 0},
              });
            }
          }
          if (key.includes(formatToday)) {
            const lengthObj = birthdayListInMonth[key];
            //console.log("lengthObj", lengthObj);
            if (lengthObj.length <= 0) {
            } else {
              lengthObj.forEach(o => {
                //console.log("nameUser", name)
                setBirthOfUser(lengthObj);
              });
            }
          }
        }

        const convertArr = Object.assign({}, ...lstBdUser);
        setArrBdCurrentMonth(convertArr);
      }
    }
  };

  const onCalendarChangeMonth = time => {
    dispatch(getBirthDayUserByDate(time.month, time.year));
  };
  const addMoreImgFromGallery = index => {
    launchImageLibrary(
      {
        mediaType: 'photo',
        includeBase64: true,
      },
      response => {
        //console.log('res', response);
        if (!response.didCancel) {
          //console.log('res', response.assets)
          const {assets} = response;
          //console.log('res', assets)
          let clone = modalVisible.birthdayArr;
          //console.log("index", clone[index])
          clone[index].imgArr = assets;
          //console.log('index', clone);

          setModalVisible(prev => ({...prev, birthdayArr: clone}));
          //console.log("index", clone[index])
        }
      },
    );
  };
  // component
  const SlidePersonnel = () => {
    // console.log('arrPersonnel', arrPersonnel);
    return (
      <Swiper
        style={{
          height: 300,
        }}
        showsButtons={false}
        loop={false}
        showsPagination={false}
        autoplay
        autoplayTimeout={5}
        activeDot={
          <View
            style={{
              backgroundColor: '#007aff',
              width: 25,
              height: 8,
              borderRadius: 4,
            }}
          />
        }>
        {arrPersonnel &&
          arrPersonnel.length > 0 &&
          arrPersonnel.map((item, index) => {
            //console.log(item);
            return (
              <View
                key={index}
                style={[
                  styles.viewContent,
                  {
                    justifyContent: 'center',
                    alignItems: 'center',
                  },
                ]}>
                <Image
                  source={
                    (item.cover_image && {
                      uri: 'https://meu.anawork.com' + item.cover_image,
                    }) ||
                    IMAGES.ImageCoverBg
                  }
                  style={styles.coverImage}
                />
                <TouchableOpacity
                  style={styles.viewAvatar}
                  onPress={() => OpenProfileUserComponent(item)}>
                  <Image
                    source={{
                      uri: 'https://meu.anawork.com' + item.avatar,
                    }}
                    style={styles.imgAvatar}
                  />
                </TouchableOpacity>
                <AppText style={{color: 'black', fontSize: 18}}>
                  {`${item.first_name} ${
                    item.middle_name ? item.middle_name : ''
                  } ${item.last_name}`}{' '}
                </AppText>
                <AppText style={{marginBottom: 20}}>{item.position}</AppText>
              </View>
            );
          })}
      </Swiper>
    );
  };
  const openCheckInPage = () => {
    // setOpenCheckIn(<CheckInPage />);
  };

  const OpenProfileUserComponent = info => {
    //console.log('info', info);
    return setOpenProfileComponent(
      <ProfileUserComponent
        userDetails={info}
        onClose={onCloseProfileComponent}
      />,
    );
  };
  const onCloseProfileComponent = () => {
    //console.log('onCloseProfileComponent');
    return setOpenProfileComponent();
  };

  // fetch data
  const fetchQuotations = () => {
    dispatch(getRadomQuotation());
  };
  const fetchDirectManagers = () => {
    dispatch(getUserDirectManagers());
  };
  const fetchBirthDayUser = () => {
    const date = new Date();
    const month =
      date.getMonth() > 8 ? date.getMonth() + 1 : '0' + (date.getMonth() + 1);
    //console.log(month)
    dispatch(getBirthDayUser({month, year: date.getFullYear()}));
  };
  //----------------------------- IMCHECKIN MODAL-----------------------------------------//
  const toggleImCheckInModal = () => setShowModalInstall(!showModalInstall);

  const initialFetchData = () => {
    fetchQuotations();
    fetchBirthDayUser();
    loadWishUser();
    loadListPersonnel();
    fetchDirectManagers();
  };

  const downloadComponent = async () => {
    setLoading(true);
  };
  const navigateToChatAssistant = () => {
    RootNavigation.navigate(APP_NAVIGATE_SCREEN.CHAT_ASSISTANT);
  };

  // useEffect
  useEffect(() => {
    const backAction = () => {
      Alert.alert('Hold on!', 'Are you sure you want to go back?', [
        {
          text: 'Cancel',
          onPress: () => null,
          style: 'cancel',
        },
        {text: 'YES', onPress: () => BackHandler.exitApp()},
      ]);
      return true;
    };
    const backHandler = BackHandler.addEventListener(
      'hardwareBackPress',
      backAction,
    );
    initialFetchData();
    return () => {
      backHandler.remove();
    };
  }, []);

  useEffect(() => {
    birthdayListInMonth && formatDateList();
  }, [birthdayListInMonth]);

  //props
  const homeProps = {
    userInfo,
    quotationList,
    birthdayOfUser,
    dataBirthday,
    openView,
    bdUserCurrentMonth,
    modalVisible,
    arrPersonnel,
    wishTxt,
    wishList,
    openProfileComponent,
    randomQuotation,
    showModalInstall,
    downloadComponent,
    setShowModalInstall,
    OpenProfileUserComponent,
    setWishTxt,
    sendWishBirthday,
    SlidePersonnel,
    toggleImCheckInModal,
    openModalHappyBirthday,
    closeModalHappyBirthday,
    openModalWishBirthday,
    closeModalWishBirthday,
    OpenURLButton,
    handleOpenDesBirthday,
    handleCloseDesBirthday,
    addMoreImgFromGallery,
    onCalendarChangeMonth,
    openCheckInPage,
    navigateToChatAssistant,
  };
  return <HomeMainView {...homePropsProvider(homeProps)} />;
};

export default HomeContainer;
