import React from 'react';
import {
  Dimensions,
  StyleSheet,
  View,
  Modal,
  Image,
  TouchableOpacity,
  ScrollView,
} from 'react-native';
import commonStyles from '../../../styles/commonStyles';
import AppText from '../../../components/AppText';
import colors from '../../../values/colors';
import {IMAGES} from '../../../assets/images';
import {ArrowLeftSVG} from '../../../assets/svg';
import {Button} from 'react-native-paper';
import ImCheckInModule from 'ImCheckInModule';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('window').height;
const ImCheckInInstall = props => {
  const {showModalInstall, toggleImCheckInModal, downloadComponent} = props;
  //console.log('userDetails', userDetails);
  return (
    <Modal
      style={[commonStyles.baseShadow, styles.backBtn]}
      animationType="slide"
      transparent={true}
      visible={showModalInstall}>
      <View style={[styles.contentContainer]}>
        <TouchableOpacity style={styles.backBtn} onPress={toggleImCheckInModal}>
          <ArrowLeftSVG width={30} height={30} />
        </TouchableOpacity>
        <ImCheckInModule />
      </View>
    </Modal>
  );
};
const styles = StyleSheet.create({
  contentContainer: {
    width: windowWidth,
    height: windowHeight,
  },
  backBtn: {top: 10, position: 'absolute', zIndex: 100},
});
export default ImCheckInInstall;
