import React from 'react';
import {
  Dimensions,
  Image,
  StyleSheet,
  TouchableOpacity,
  View,
} from 'react-native';
import ButtonComponent from '../../../components/ButtonComponent';
import {IMAGES} from '../../../values/images';
import AppText from '../../../components/AppText';
const windowWidth = Dimensions.get('window').width;
const ProfileUserComponent = ({userDetails, onClose}) => {
  //console.log('userDetails', userDetails);
  return (
    <View style={styles.container}>
      <View>
        <ButtonComponent
          style={{position: 'absolute', top: 0, right: 0, zIndex: 100}}
          iconSource={IMAGES.IcCloseGrey}
          onPress={onClose}
          styleIcon={{width: 30, height: 30}}
        />
        <View
          style={[
            styles.viewContent,
            {justifyContent: 'center', alignItems: 'center'},
          ]}>
          <Image
            source={
              (userDetails?.cover_image && {
                uri: 'https://meu.anawork.com' + userDetails?.cover_image,
              }) ||
              IMAGES.ImageCoverBg
            }
            style={styles.coverImage}
          />
          <TouchableOpacity style={styles.viewAvatar}>
            <Image
              source={{
                uri: 'https://meu.anawork.com' + userDetails.avatar,
              }}
              style={styles.imgAvatar}
            />
          </TouchableOpacity>
          <AppText style={{color: 'black', fontSize: 18}}>
            {`${userDetails.extend_user_full_name}`}
          </AppText>
          <AppText style={{marginBottom: 20}}>{userDetails.position}</AppText>
        </View>
        <View style={[styles.viewContent, {padding: 10}]}>
          <View style={{borderBottomWidth: 1}}>
            <AppText style={{fontSize: 17, color: 'black'}}>
              Thông tin cá nhân
            </AppText>
          </View>
          <View style={styles.viewInfo}>
            <View style={{flex: 1, flexDirection: 'row'}}>
              <Image source={IMAGES.IcInfoGuess} style={{marginRight: 10}} />
              <View>
                <AppText>Họ và tên</AppText>
                <AppText style={styles.subTxt}>
                  {userDetails.extend_user_full_name}
                </AppText>
              </View>
            </View>
          </View>
          <View style={styles.viewInfo}>
            <View style={{flex: 1, flexDirection: 'row'}}>
              <Image source={IMAGES.IcInfoGuess} style={{marginRight: 10}} />
              <View>
                <AppText>Giới tính</AppText>
                <AppText style={styles.subTxt}>
                  {userDetails.gender ? 'Nam' : 'Nữ'}
                </AppText>
              </View>
            </View>
          </View>
          <View style={{...styles.viewInfo, flexDirection: 'row'}}>
            <Image
              source={IMAGES.IcPhone}
              style={{marginRight: 10, height: 20, width: 20}}
            />
            <View>
              <AppText>Số điện thoại</AppText>
              <AppText style={styles.subTxt}>{userDetails.cell_phone}</AppText>
            </View>
          </View>
          <View style={{flexDirection: 'row'}}>
            <Image
              source={IMAGES.IcMailGray}
              style={{marginRight: 10, height: 20, width: 20}}
            />
            <View>
              <AppText>Email</AppText>
              <AppText style={styles.subTxt}>{userDetails.email}</AppText>
            </View>
          </View>
        </View>
      </View>
    </View>
  );
};
const styles = StyleSheet.create({
  container: {
    backgroundColor: 'white',
    position: 'absolute',
    padding: 10,
    bottom: 0,
    borderTopLeftRadius: 10,
    borderTopRightRadius: 10,
    width: '100%',
    justifyContent: 'flex-end',
    minHeight: '50%',
    flex: 1,
  },
  viewContent: {
    borderWidth: 1,
    width: windowWidth - 20,
    borderColor: 'white',
    backgroundColor: 'white',
    alignSelf: 'center',
    marginTop: 10,
    marginBottom: 10,
  },
  coverImage: {
    width: windowWidth - 5,
    height: 120,
    resizeMode: 'cover',
  },
  viewAvatar: {
    borderWidth: 5,
    borderRadius: 60,
    borderColor: 'white',
    marginTop: -50,
    backgroundColor: 'white',
  },
  imgAvatar: {
    width: 90,
    height: 90,
    resizeMode: 'contain',
    alignSelf: 'center',
    borderRadius: 60,
  },
  viewInfo: {
    flexDirection: 'row',
    borderBottomWidth: 0.2,
    borderBottomColor: 'grey',
    marginTop: 5,
    paddingTop: 5,
    paddingBottom: 5,
  },
  subTxt: {
    color: 'black',
    fontWeight: 'bold',
  },
});
export default ProfileUserComponent;
