/* eslint-disable prettier/prettier */
import React from 'react';
import {
  Dimensions,
  Image,
  StyleSheet,
  TouchableOpacity,
  View,
} from 'react-native';
import FastImage from 'react-native-fast-image';
import {GifType} from '../../../values/images';
import AppText from '../../../components/AppText';
const windowWidth = Dimensions.get('window').width;
const WishListComponent = ({
  userDetails,
  openView,
  openModalHappyBirthday,
  closeModalHappyBirthday,
  dataBirthday,
}) => {
  return (
    <View style={styles.viewContent}>
      <AppText style={[styles.txtTitle, {padding: 10}]}>
        Lời chúc sinh nhật
      </AppText>

      {dataBirthday.map((item, index) => (
        <View
          key={index}
          style={[
            styles.viewHappyBirthday,
            openView[index].enable
              ? styles.openViewHappyBirthday
              : styles.closeViewHappyBirthday,
          ]}>
          <View style={{flexDirection: 'row'}}>
            <View
              style={{
                flexDirection: 'row',
                flex: openView[index].enable ? 1 : 0,
              }}>
              <Image
                source={{
                  uri: 'https://meu.anawork.com' + item.extend_avatar,
                }}
                style={{width: 40, height: 40}}
              />
              <View style={{paddingLeft: 10}}>
                <AppText style={styles.txtTitle}>
                  {item.extend_sender_full_name}
                </AppText>
                <AppText>{item.position}</AppText>
              </View>
            </View>
            {!openView[index].enable && (
              <View style={{alignItems: 'flex-end', flex: 1}}>
                <TouchableOpacity
                  onPress={() => openModalHappyBirthday(index)}
                  style={styles.btnOpenHappyBirthday}>
                  <AppText style={{color: 'blue', fontWeight: '500'}}>
                    Xem
                  </AppText>
                </TouchableOpacity>
              </View>
            )}
          </View>
          {openView[index].enable && (
            <View>
              <View style={{marginTop: 10}}>
                <AppText style={[styles.txtTitle]}>{item?.details}</AppText>
                {item.image_path && (
                  <Image
                    source={{
                      uri: 'https://meu.anawork.com' + item.image_path,
                    }}
                    style={{
                      width: 60,
                      height: 60,
                      alignSelf: 'center',
                      marginTop: 10,
                    }}
                  />
                )}
                {!item.image_path && (
                  <FastImage
                    source={GifType.gifBirthdayCake}
                    style={{
                      width: 60,
                      height: 60,
                      alignSelf: 'center',
                      marginTop: 10,
                    }}
                  />
                )}
              </View>
              <TouchableOpacity
                onPress={() => closeModalHappyBirthday(index)}
                style={{alignSelf: 'flex-end'}}>
                <AppText style={{color: 'blue', fontWeight: '600'}}>
                  {' '}
                  Đóng
                </AppText>
              </TouchableOpacity>
            </View>
          )}
        </View>
      ))}
    </View>
  );
};
const styles = StyleSheet.create({
  viewContent: {
    borderWidth: 1,
    width: windowWidth - 20,
    borderColor: 'white',
    backgroundColor: 'white',
    alignSelf: 'center',
    marginTop: 10,
    marginBottom: 10,
  },
  txtTitle: {
    color: 'black',
    fontSize: 15,
    fontWeight: '500',
  },
  openViewHappyBirthday: {
    borderLeftWidth: 4,
    borderLeftColor: 'blue',
  },
  closeViewHappyBirthday: {
    borderLeftWidth: 1,
  },
  viewHappyBirthday: {
    padding: 20,
    marginVertical: 8,
    marginHorizontal: 16,
    borderWidth: 1,
    borderBottomColor: '#f2f2f2',
    borderTopColor: '#f2f2f2',
    borderRightColor: '#f2f2f2',
    borderTopLeftRadius: 10,
    borderBottomLeftRadius: 10,
    justifyContent: 'space-between',
  },
});
export default WishListComponent;
