import React from 'react';

import {useSelector} from 'react-redux';
import HomeContainer from './homeContainer';
import {authSelector, homeSelector} from '../../app/selectors';

export default function HomeScreen() {
  const homeSelect = useSelector(homeSelector);
  const authSelect = useSelector(authSelector);

  const {userInfo} = authSelect;
  const {quotationList, birthdayListInMonth, randomQuotation} = homeSelect;

  const homeScreenProps = {
    userInfo,
    quotationList,
    birthdayListInMonth,
    randomQuotation,
  };
  return <HomeContainer {...homeScreenProps} />;
}
