import React, {memo} from 'react';
import {
  Image,
  Modal,
  ScrollView,
  TextInput,
  TouchableOpacity,
  View,
} from 'react-native';
import FastImage from 'react-native-fast-image';
import AppText from '../../../components/AppText';
import ButtonComponent from '../../../components/ButtonComponent';
import config from '../../../config';
import commonStyles from '../../../styles/commonStyles';
import {IMAGES, IconProfile} from '../../../values/images';
import styles from '../style';
const BirthdayModal = React.memo(
  props => {
    const {
      modalVisible,
      handleCloseDesBirthday,
      openModalWishBirthday,
      addMoreImgFromGallery,
      closeModalWishBirthday,
      closeModalHappyBirthday,
    } = props;
    return (
      <Modal
        style={commonStyles.baseShadow}
        animationType="slide"
        transparent={true}
        visible={modalVisible.isVisible}>
        <View
          style={{flex: 1, justifyContent: 'flex-end'}}
          //activeOpacity={0}
          //onPress={handleCloseDesBirthday}
        >
          <View style={styles.contentContainer}>
            <ScrollView>
              <ButtonComponent
                iconSource={IconProfile.IcCloseBlack}
                styleIcon={{width: 20, height: 20}}
                style={{
                  alignSelf: 'flex-end',
                  marginRight: 10,
                  marginTop: 10,
                }}
                onPress={handleCloseDesBirthday}
              />
              <AppText
                style={{color: 'black', fontWeight: 'bold', fontSize: 14}}>
                {`Ngày ${modalVisible?.day?.day} tháng ${modalVisible?.day?.month} năm ${modalVisible?.day?.year} 🎉`}
              </AppText>
              {modalVisible?.birthdayArr?.map((item, index) => (
                <View
                  key={index}
                  style={[
                    styles.viewHappyBirthday,
                    modalVisible?.managerOpenWish[index].enable
                      ? styles.openViewHappyBirthday
                      : styles.closeViewHappyBirthday,
                  ]}>
                  <View
                    style={{
                      flexDirection: 'row',
                      justifyContent: 'space-between',
                    }}>
                    <View style={{flexDirection: 'row'}}>
                      <Image
                        source={
                          item.avatar
                            ? {
                                uri: config.imageEndPoint + item.avatar,
                              }
                            : IMAGES.IcAvatarDefault
                        }
                        style={{width: 40, height: 40, borderRadius: 5}}
                      />
                      <View style={{paddingLeft: 10}}>
                        <AppText
                          style={
                            styles.txtTitle
                          }>{`${item.first_name} ${item.middle_name} ${item.last_name}`}</AppText>
                        <AppText>{item.position}</AppText>
                      </View>
                    </View>
                    {/* {!modalVisible?.managerOpenWish[index].enable && (
                      <View
                        style={{
                          justifyContent: 'center',
                          alignItems: 'center',
                        }}>
                        <TouchableOpacity
                          onPress={() => openModalWishBirthday(index)}
                          style={styles.btnOpenHappyBirthday}>
                          <Image
                            source={IMAGES.IcOutlineSend}
                            style={{width: 10, height: 10}}
                          />
                        </TouchableOpacity>
                      </View>
                    )} */}
                  </View>
                  {modalVisible?.managerOpenWish[index].enable && (
                    <View>
                      <View style={{marginTop: 10}}>
                        <TextInput
                          multiline
                          numberOfLines={3}
                          placeholder={'Vui lòng nhập lời chúc tại đây'}
                          style={{borderWidth: 0.2}}
                        />
                        {/** suggest wish  */}
                        <View>
                          <ButtonComponent
                            style={styles.btnSuggest}
                            text={'Chúc bà sinh nhật dui dẻ nha 🌺'}
                            textStyle={{color: 'white'}}
                          />
                          <ButtonComponent
                            style={styles.btnSuggest}
                            text={'Tuổi mới sinh đẹp nhaaaa 🌺💃'}
                            textStyle={{color: 'white'}}
                          />
                        </View>
                        <View style={{flexDirection: 'row'}}>
                          {item?.imgArr &&
                            item?.imgArr.map((el, position) => {
                              return (
                                <View key={position} style={{marginRight: 10}}>
                                  <FastImage
                                    source={{
                                      uri: el.uri,
                                    }}
                                    style={{
                                      width: 60,
                                      height: 60,
                                      marginTop: 10,
                                    }}
                                  />
                                </View>
                              );
                            })}
                          {!item.imgArr && (
                            <View style={styles.viewAddMoreImg}>
                              <ButtonComponent
                                iconSource={IMAGES.IcAddMoreImg}
                                styleIcon={{height: 25, width: 25}}
                                onPress={() => addMoreImgFromGallery(index)}
                              />
                            </View>
                          )}
                        </View>
                      </View>
                      <View
                        style={{
                          flexDirection: 'row',
                          justifyContent: 'space-between',
                          marginTop: 10,
                        }}>
                        <TouchableOpacity
                          onPress={() => closeModalWishBirthday(index)}
                          style={{alignSelf: 'flex-end'}}>
                          <AppText style={{color: 'blue', fontWeight: '600'}}>
                            {' '}
                            Hủy{' '}
                          </AppText>
                        </TouchableOpacity>
                        <TouchableOpacity
                          onPress={() => closeModalHappyBirthday(index)}
                          style={{alignSelf: 'flex-end'}}>
                          <AppText style={{color: 'blue', fontWeight: '600'}}>
                            Gửi
                          </AppText>
                        </TouchableOpacity>
                      </View>
                    </View>
                  )}
                </View>
              ))}
            </ScrollView>
          </View>
        </View>
      </Modal>
    );
  },
  function areEqual(prevProps, nextProps) {
    return prevProps.modalVisible === nextProps.modalVisible;
  },
);

export default memo(BirthdayModal);
