import {StyleSheet, Dimensions} from 'react-native';
import colors from '../../values/colors';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('screen').height;
const styles = StyleSheet.create({
  container: {
    flex: 1,
  },
  viewContent: {
    borderRadius: 5,
    borderWidth: 1,
    width: windowWidth - 20,
    borderColor: colors.white,
    backgroundColor: colors.white,
    alignSelf: 'center',
    margin: 10,
  },
  bgQuote: {
    width: windowWidth - 10,
    height: '100%',
    resizeMode: 'contain',
  },
  text: {
    fontSize: 18,
    fontFamily: 'Roboto-medium',
    color: '#fff',
  },
  textQuote: {
    color: '#084884',
    fontSize: 15,
    textAlign: 'right',
  },
  calendarHolder: {
    margin: 10,
    borderTopLeftRadius: 15,
    borderTopRightRadius: 15,
    backgroundColor: 'white',
  },
  BgBirthday: {
    width: windowWidth - 20,
    height: 80,
    resizeMode: 'cover',
  },
  view: {
    width: windowWidth - 10,
    alignSelf: 'center',
    borderWidth: 1,
    borderRadius: 5,
    backgroundColor: 'white',
    borderColor: 'white',
    padding: 10,
    marginTop: 10,
  },
  viewHappyBirthday: {
    padding: 20,
    marginVertical: 8,
    marginHorizontal: 16,
    borderWidth: 1,
    borderBottomColor: '#f2f2f2',
    borderTopColor: '#f2f2f2',
    borderRightColor: '#f2f2f2',
    borderTopLeftRadius: 10,
    borderBottomLeftRadius: 10,
    justifyContent: 'space-between',
  },
  openViewHappyBirthday: {
    borderLeftWidth: 4,
    borderLeftColor: 'blue',
  },
  closeViewHappyBirthday: {
    borderLeftWidth: 1,
  },
  txtTitle: {
    color: 'black',
    fontSize: 15,
    fontWeight: '500',
  },
  btnOpenHappyBirthday: {
    borderWidth: 1,
    borderColor: 'blue',
    borderRadius: 8,
    justifyContent: 'center',
    alignItems: 'center',
    padding: 10,
  },
  contentContainer: {
    backgroundColor: 'white',
    padding: 10,
    paddingBottom: 50,
    // position: 'absolute',
    // bottom: 0,

    width: '100%',
    minHeight: '50%',
  },
  viewAddMoreImg: {
    padding: 10,
    borderWidth: 1,
    width: 60,
    height: 60,
    justifyContent: 'center',
    alignItems: 'center',
    borderStyle: 'dotted',
    borderColor: 'blue',
    marginTop: 10,
  },
  btnSuggest: {
    padding: 5,
    borderRadius: 10,
    borderWidth: 0.5,
    borderColor: 'white',
    width: '90%',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginVertical: 8,
    backgroundColor: colors.royal_blue,
  },
  imgAvatar: {
    width: 90,
    height: 90,
    resizeMode: 'contain',
    alignSelf: 'center',
    borderRadius: 60,
  },
  coverImage: {
    width: windowWidth - 20,
    height: 200,
    resizeMode: 'cover',
  },
  viewImageProfile: {
    width: windowWidth - 20,
    height: 370,
    alignItems: 'center',
    borderWidth: 1,
    backgroundColor: colors.white,
    borderColor: colors.white,
    marginBottom: 10,
  },
  viewAvatar: {
    borderWidth: 5,
    borderRadius: 60,
    borderColor: 'white',
    marginTop: -50,
    backgroundColor: 'white',
  },
  assistant: {
    width: 100,
    height: 100,
  },
  btnAssistant: {
    position: 'absolute',
    top: windowHeight / 2,
    right: 0,
    zIndex: 100,
  },
});
export default styles;
