import React from 'react';
import {Image, SafeAreaView, ScrollView, TouchableOpacity} from 'react-native';
import styles from '../style';

import LottieView from 'lottie-react-native';
import {IMAGES} from '../../../assets/images';
import VirtualAssistant from '../../../mockup/assistant.json';
import ImCheckInInstall from '../components/ImCheckInInstall';
import WishListComponent from '../components/WishListComponent';
import BirthdayModal from '../modals/BirthdayModals';
import CalendarBirthday from './subViews/CalendarBirthday';
import Quotation from './subViews/QuotationList';

const HomeMainView = props => {
  const {
    userInfo,
    openView,
    openModalHappyBirthday,
    closeModalHappyBirthday,
    wishList,
    openProfileComponent,
    openCheckIn,
    calendarBirthdayProps,
    randomQuotation,
    birthdayModalProps,
    imCheckInInstall,
    toggleImCheckInModal,
    navigateToChatAssistant,
  } = props;
  return (
    <SafeAreaView style={styles.container}>
      <TouchableOpacity
        style={styles.btnAssistant}
        onPress={navigateToChatAssistant}>
        <LottieView
          source={VirtualAssistant} // File Lottie của bạn
          style={styles.assistant}
          loop={true}
          autoPlay
          duration={5000}
        />
      </TouchableOpacity>
      {!openCheckIn && (
        <ScrollView
          nestedScrollEnabled={true}
          showsVerticalScrollIndicator={false}>
          <TouchableOpacity
            style={{borderRadius: 5, margin: 10}}
            onPress={toggleImCheckInModal}>
            <Image
              source={IMAGES.ImCheckInLogo}
              style={{width: 50, height: 50, borderRadius: 5}}
            />
          </TouchableOpacity>
          <Quotation quotation={randomQuotation} />
          {/*Calendar*/}
          <CalendarBirthday {...calendarBirthdayProps} />
          {/*wish */}
          {wishList.length > 0 && (
            <WishListComponent
              userDetails={userInfo}
              openView={openView}
              openModalHappyBirthday={openModalHappyBirthday}
              closeModalHappyBirthday={closeModalHappyBirthday}
              dataBirthday={wishList}
            />
          )}
        </ScrollView>
      )}

      <BirthdayModal {...birthdayModalProps} />
      <ImCheckInInstall {...imCheckInInstall} />

      {openProfileComponent && openProfileComponent}
    </SafeAreaView>
    // <SafeAreaView style={styles.container}>
    //   <ImCheckInModule />
    // </SafeAreaView>
  );
};

export default HomeMainView;
