import moment from 'moment';
import React, {memo} from 'react';
import {Image, TouchableOpacity, View} from 'react-native';
import {Calendar} from 'react-native-calendars';
import Swiper from 'react-native-swiper';
import {fonts} from '../../../../assets/fonts/fonts';
import AppText from '../../../../components/AppText';
import colors from '../../../../values/colors';
import {IMAGES} from '../../../../values/images';
import styles from '../../style';
import commonStyles from '../../../../styles/commonStyles';
const CalendarBirthday = React.memo(
  ({
    birthdayOfUser,
    bdUserCurrentMonth,
    handleOpenDesBirthday,
    onCalendarChangeMonth,
  }) => {
    const today = moment(moment()).format('YYYY-MM-DD'); // Today
    return (
      <View style={[styles.viewContent, commonStyles.baseShadow]}>
        <Image source={IMAGES.BgBirthdayHeader} style={styles.BgBirthday} />
        {birthdayOfUser && (
          <Swiper
            style={styles.BgBirthday}
            showsButtons={false}
            loop={true}
            autoplay
            index={0}>
            {birthdayOfUser &&
              birthdayOfUser.length > 0 &&
              birthdayOfUser.map((item, index) => {
                //console.log("index")
                return (
                  <TouchableOpacity
                    onPress={() => {
                      const day = {
                        day: new Date().getDate(),
                        month: new Date().getMonth() + 1,
                        year: new Date().getFullYear(),
                      };
                      handleOpenDesBirthday(day);
                      //console.log(day)
                    }}
                    key={item.id}
                    style={{marginTop: 10}}>
                    <AppText
                      style={{
                        fontSize: 13,
                        color: 'blue',
                        textAlign: 'center',
                      }}>
                      {`Hôm nay là sinh nhật ${item.first_name} ${item.middle_name} ${item.last_name} `}
                    </AppText>
                    <AppText
                      style={{
                        fontSize: 13,
                        color: 'blue',
                        textAlign: 'center',
                      }}>
                      hãy gửi lời chúc mừng nào
                    </AppText>
                    <AppText
                      style={{
                        fontSize: 13,
                        textAlign: 'center',
                      }}>
                      💖
                    </AppText>
                  </TouchableOpacity>
                );
              })}
          </Swiper>
        )}
        <Calendar
          style={styles.calendarHolder}
          current={today}
          markedDates={bdUserCurrentMonth}
          markingType="dot"
          onDayPress={day => {
            handleOpenDesBirthday(day);
          }}
          onMonthChange={month => onCalendarChangeMonth(month)}
          enableSwipeMonths={false}
          theme={{
            //day section
            textDayFontSize: 13,
            textDayFontFamily: fonts.beProMedium,
            todayTextColor: colors.green,
            dayTextColor: colors.black,
            textDisabledColor: 'rgba(0, 0, 0, 0.25)',
            textDayFontWeight: '600',
            //month section
            textMonthFontSize: 18,
            textMonthFontFamily: fonts.beProMedium,
            monthTextColor: colors.black,
            textMonthFontWeight: 'bold',
            //header section
            textDayHeaderFontSize: 16,
            textDayHeaderFontFamily: fonts.beProMedium,
            textSectionTitleColor: 'rgba(0, 0, 0, 0.25)',
            textDayHeaderFontWeight: '300',
            //selected day section
            selectedDayBackgroundColor: '#dcf7fc',
            selectedDayTextColor: colors.black,
            //arrow section
            arrowColor: '#fa0000',

            //dot section
            selectedDotColor: '#dcf7fc',
          }}
        />
      </View>
    );
  },
  function (prevProps, nextProps) {
    return prevProps.bdUserCurrentMonth === nextProps.bdUserCurrentMonth;
  },
);

export default memo(CalendarBirthday);
