import React from 'react';
import {Dimensions, Image, StyleSheet, View} from 'react-native';
import AppText from '../../../../components/AppText';
import {IMAGES} from '../../../../values/images';
import commonStyles from '../../../../styles/commonStyles';
const windowWidth = Dimensions.get('window').width;
const Quotation = ({quotation}) => {
  return (
    <View style={[styles.quotationContainer, commonStyles.baseShadow]}>
      <View style={styles.quotationContent}>
        <AppText style={styles.textQuote}>
          {quotation?.content
            ? quotation?.content
            : `If you cannot do greats things, do small things in a great way`}
        </AppText>
        <AppText>
          {quotation?.name ? '-' + quotation?.name : `-Napoleon Hill`}
        </AppText>
      </View>
      <Image style={styles.bgQuote} source={IMAGES.BgQuote} />
    </View>
  );
};
const styles = StyleSheet.create({
  quotationContainer: {
    borderWidth: 1,
    borderColor: 'white',
    backgroundColor: 'white',
    paddingTop: 30,
    borderRadius: 5,
    margin: 10,
  },
  quotationContent: {
    justifyContent: 'center',
    alignItems: 'center',
    padding: 10,
  },
  bgQuote: {
    width: windowWidth - 10,
    height: 120,
    resizeMode: 'contain',
  },
  textQuote: {
    color: '#084884',
    fontSize: 15,
    textAlign: 'right',
  },
});
export default Quotation;
