import Moment from 'moment';
import React, {useEffect, useState} from 'react';
import Toast from 'react-native-toast-message';
import {useDispatch} from 'react-redux';
import RootNavigation from '../../navigation/RootNavigation';
import {
  deleteNotificationUser,
  getNotificationOfUser,
  readNotificationUser,
} from '../../store/actions/UserAction';
import {APP_NAVIGATE_SCREEN} from '../../utils/constant';
import {IcNotificationList} from '../../values/images';
import {getNotification} from './notificationSlice';
import NotificationMainView from './template/NotificationMainView';

const NotificationContainer = props => {
  const {notificationList, userInfo} = props;
  const dispatch = useDispatch();
  // state
  const [notiList, setNotiList] = useState([]);
  const [isLoading, setLoading] = useState(false);

  const [payload, setPayload] = useState({
    filter: 'main_category_type==',
    page: 1,
    limit: 10,
    sort: '',
  });
  const [showAlert, setShowAlert] = useState({
    isError: false,
    title: '',
    message: '',
    deleteItem: '',
  });

  const [arrBtnHeader, setBtnHeader] = useState([
    {
      icon: IcNotificationList.IcSelectAll,
      type: 'All Notification',
      tab: 'all',
      isSelected: true,
      unread: 0,
      iconActive: IcNotificationList.IcSelectAllWhite,
    },
    {
      icon: IcNotificationList.IcLeaveNoti,
      type: 'nghỉ phép',
      tab: 'leave',
      isSelected: false,
      unread: 0,
      iconActive: IcNotificationList.IcLeaveNotiWhite,
    },
    {
      icon: IcNotificationList.IcOtNoti,
      type: 'Tăng ca',
      tab: 'ot',
      isSelected: false,
      unread: 0,
      iconActive: IcNotificationList.IcOtNotiWhite,
    },
    {
      icon: IcNotificationList.IcTimeSheetNoti,
      type: 'timesheet',
      tab: 'timesheet',
      isSelected: false,
      unread: 0,
      iconActive: IcNotificationList.IcTimeSheetNotiWhite,
    },
    {
      icon: IcNotificationList.IcSalaryNoti,
      type: 'Phiếu lương',
      tab: 'salary',
      isSelected: false,
      unread: 0,
      iconActive: IcNotificationList.IcSalaryNotiWhite,
    },
  ]);

  // function handle
  const loadAllNotification = async query => {
    const arrNoti = await dispatch(
      getNotification({
        filter: payload.filter,
        page: payload.page,
        pageSize: payload.limit,
      }),
    );
    //.log("arrNoti", arrNoti)
    if (arrNoti.length > 0) {
      // await arrNoti.forEach(async item => {
      //   const resGetInfoUser = await dispatch(getUserInfoById(item.user_id));
      //   if (resGetInfoUser) {
      //     item.extend_user_full_name = resGetInfoUser.extend_user_full_name;
      //     item.avatar = resGetInfoUser.avatar;
      //     setNotiList(prev => [...prev, item]);
      //     //console.log(item);
      //   }
      // });
      setNotiList(prev => [...prev, ...arrNoti]);
      //console.log("arrNoti", arrNoti)
      //setNotiList(prev => [...prev, ...arrNoti]);

      //loadBadgeNotification(arrNoti);
      // const merge = notiList.concat(arrNoti)
      // setNotiList(merge)
    }
  };

  const readNotification = async (item, index) => {
    const res = await dispatch(readNotificationUser(item.id));
    if (res.success) {
      const clone = [...notiList];
      item.read = true;
      clone[index] = item;
      setNotiList(clone);
      //console.log('res.data.group_code', res.data.group_code)
      switch (res.data.group_code) {
        case 'Vắng mặt':
          RootNavigation.navigate(APP_NAVIGATE_SCREEN.CONFIRM_DATE, {
            refId: item.ref_id,
          });
          break;
        case 'nghỉ phép':
          RootNavigation.navigate(APP_NAVIGATE_SCREEN.ON_LEAVE, {
            refId: item.ref_id,
          });
          break;
        case 'Tăng ca':
          RootNavigation.navigate(APP_NAVIGATE_SCREEN.OVERTIME, {
            refId: item.ref_id,
          });
          break;
        case 'Phiếu lương':
          RootNavigation.navigate(APP_NAVIGATE_SCREEN.SALARY, {
            refId: item.ref_id,
          });
          break;
      }
    }
  };
  const calculateTimeNoti = timeNoti => {
    var current = new Moment();
    var time_noti = new Moment(timeNoti);
    var duration = Moment.duration(current.diff(time_noti))
      .asHours()
      .toFixed(0);

    if (duration < 0 || duration > 24) {
      return Moment(timeNoti).format('DD/MM/YYYY');
    } else if (Number(duration) === 0) {
      return Moment.duration(current.diff(time_noti)).asMinutes().toFixed(0);
    } else {
      return duration + ' Giờ';
    }
  };
  const onDeleteNotification = (item, index) => {
    setShowAlert({
      isError: true,
      title: 'Hệ thống',
      message: 'Bạn có muốn xóa thông báo này không ?',
      deleteItem: item,
    });
  };
  const hideAlert = () => {
    setShowAlert({
      isError: false,
      title: '',
      message: '',
      deleteItem: '',
    });
  };
  const onConfirmDelete = async () => {
    //console.log('onConfirmDelete', showAlert.deleteItem.id)
    const res = await dispatch(deleteNotificationUser(showAlert.deleteItem.id));
    if (res.success) {
      const clone = [...notiList];
      const arrLst = clone.filter(el => el !== showAlert.deleteItem);
      setNotiList(arrLst);
      hideAlert();
      Toast.show({
        type: 'success',
        text1: 'Hệ thống',
        text2: 'Bạn đã xóa thành công !!!',
        style: {zIndex: 1001},
      });
    } else {
      Toast.show({
        type: 'error',
        text1: 'Hệ thống',
        text2: 'Đã có lỗi xảy ra !!!',
        style: {zIndex: 1001},
      });
    }
  };
  const onChangeTab = (g_code, tab, index, item) => {
    let clone = [...arrBtnHeader];
    // clone.splice(index, 1, { ...item, isSelected: true })
    clone.forEach((item, i) => {
      if (i !== index) {
        item.isSelected = false;
      } else {
        item.isSelected = true;
      }
    });
    // item.isSelected = true
    // clone[index] = item
    setBtnHeader(clone);
    if (tab === 'all') {
      loadAllNotification(`?Sorts=&Page=1&PageSize=10`);
      return;
    }
    //console.log("resTab", resTab)
    setNotiList([]);
    setPayload(prev => ({
      ...prev,
      filter: `group_code==${g_code}`,
      page: 1,
    }));
  };
  const onRefreshList = () => {
    console.log('onRefreshList');
  };
  const onLoadMore = () => {
    setPayload(prev => ({
      ...prev,
      page: payload.page + 1,
    }));

    //console.log("onLoadMore")
  };

  const loadBadgeNotification = async () => {
    const arrNoti = await dispatch(
      getNotificationOfUser(
        `?Filters=main_category_type==&Sorts=&Page=1&PageSize=1000`,
      ),
    );
    //console.log('arrNoti', arrNoti);
    let arrleave = [];
    let arrOt = [];
    let arrSalary = [];
    if (arrNoti.length > 0) {
      arrNoti.forEach((item, index) => {
        if (
          (item.group_code === 'nghỉ phép' || item.group_code === 'Vắng mặt') &&
          !item.read
        ) {
          arrleave.push(item);
        } else if (item.group_code === 'Tăng ca' && !item.read) {
          arrOt.push(item);
        } else if (item.group_code === 'Phiếu lương') {
          arrSalary.push(item);
        }
      });
      //console.log('length', lstNoti);
      let clone = [...arrBtnHeader];
      clone.forEach((item, index) => {
        switch (item.type) {
          case 'nghỉ phép':
          case 'Vắng mặt':
            //console.log(arrleave.length)
            if (arrleave.length <= 0) {
              item.unread = '0';
            } else if (arrleave.length >= 9) {
              item.unread = '9+';
            } else {
              item.unread = arrleave.length;
            }
            break;
          case 'Tăng ca':
            if (arrOt.length < 0) {
              item.unread = '0';
            } else if (arrOt.length >= 9) {
              item.unread = '9+';
            } else {
              item.unread = arrOt.length;
            }
            break;
          case 'Phiếu lương':
            if (arrSalary.length < 0) {
              item.unread = '0';
            } else if (arrSalary.length >= 9) {
              item.unread = '9+';
            } else {
              item.unread = arrSalary.length;
            }
            break;
          case 'All Notification':
            if (arrNoti.length < 0) {
              item.unread = '0';
            } else if (arrNoti.length >= 9) {
              item.unread = '9+';
            } else {
              item.unread = arrNoti.length;
            }
            break;
        }
      });
      setBtnHeader(clone);
    }
  };

  useEffect(() => {
    payload && loadAllNotification();
    // calculateTimeNoti()
  }, [payload]);

  useEffect(() => {
    loadBadgeNotification();
  }, []);

  const notiProps = {
    notificationList,
    userInfo,
    notiList,
    isLoading,
    showAlert,
    arrBtnHeader,
    loadBadgeNotification,
    readNotification,
    calculateTimeNoti,
    onDeleteNotification,
    onConfirmDelete,
    hideAlert,
    onChangeTab,
    onRefreshList,
    onLoadMore,
  };
  return <NotificationMainView {...notiProps} />;
};

export default NotificationContainer;
