import React from 'react';

import {useSelector} from 'react-redux';
import {authSelector, notificationSelector} from '../../app/selectors';
import NotificationContainer from './NotificationContainer';

export default function NotificationScreen() {
  const authSelect = useSelector(authSelector);
  const notificationSelect = useSelector(notificationSelector);

  const {userInfo} = authSelect;
  const {notificationList} = notificationSelect;
  const notificationScreenProps = {
    userInfo,
    notificationList,
  };
  return <NotificationContainer {...notificationScreenProps} />;
}
