import {createAsyncThunk, createSlice} from '@reduxjs/toolkit';

import serviceRequest from '../../app/serviceRequest';

import notificationAPI from '../../api/notificationAPI';
import Utils from '../../utils';

const initialState = {
  notificationList: [],
};

export const getNotification = createAsyncThunk(
  'notification/getNotification',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: notificationAPI.requestGetNotification,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);

const notificationSlice = createSlice({
  name: 'notification',
  initialState: initialState,
  reducers: {},
  extraReducers: builder => {
    builder.addCase(getNotification.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false); 
      if (success) {
        state.notificationList = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
  },
});

const {reducer} = notificationSlice;
export default reducer;
