import React from 'react';
import {Image, SafeAreaView, TouchableOpacity, View} from 'react-native';
import {SwipeListView} from 'react-native-swipe-list-view';
import {ScrollView} from 'react-native-virtualized-view';
import AppText from '../../../components/AppText';
import ButtonComponent from '../../../components/ButtonComponent';
import LoadingProgress from '../../../components/LoadingProgress';
import {IcNotificationList, IMAGES} from '../../../values/images';
import styles from '../style';
import config from '../../../config';
const NotificationMainView = ({
  notificationList,
  userInfo,
  readNotification,
  isLoading,
  calculateTimeNoti,
  onDeleteNotification,
  onChangeTab,
  onRefreshList,
  onLoadMore,
  arrBtnHeader,
}) => {
  const renderItem = ({item, index}) => {
    //console.log(item)
    return (
      <TouchableOpacity
        key={item.id + index}
        onPress={() => readNotification(item, index)}
        style={[styles.item, {backgroundColor: 'white'}]}>
        <Image
          source={
            item?.extend_avatar
              ? {uri: config.imageEndPoint + item?.extend_avatar}
              : IMAGES.IcAvatarDefault
          }
          style={{...styles.imgAvatar, marginRight: 5}}
        />
        <View
          style={{
            justifyContent: 'center',
            marginRight: 10,
            flex: 4,
          }}>
          <AppText style={{color: '#5d78ff', fontWeight: '500'}}>
            {item.summary}
          </AppText>
          <AppText style={styles.title}>{`${item.details}`}</AppText>
          <AppText style={{fontSize: 10}}>
            {calculateTimeNoti(item.created_at)}
          </AppText>
        </View>
        <View style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
          {
            <Image
              source={
                !item.read
                  ? IcNotificationList.IcStatusOff
                  : IcNotificationList.IcStatusDone
              }
              style={styles.iconStatus}
            />
          }
        </View>
      </TouchableOpacity>
    );
  };
  const renderHiddenItem = ({item, index}) => {
    return (
      <ButtonComponent
        style={styles.hiddenItem}
        onPress={() => onDeleteNotification(item, index)}
        iconSource={IcNotificationList.IcTrash}
        styleIcon={{width: 20, height: 20}}
      />
    );
  };

  //console.log(notiList);
  return (
    <SafeAreaView>
      <ScrollView nestedScrollEnabled={true}>
        <View style={styles.headerView}>
          {arrBtnHeader &&
            arrBtnHeader.map((item, index) => {
              return (
                <ButtonComponent
                  key={item.icon}
                  style={[
                    styles.viewIconHeader,
                    {
                      backgroundColor: item.isSelected ? '#5d78ff' : '#f1f1f1',
                    },
                  ]}
                  iconSource={item.isSelected ? item.iconActive : item.icon}
                  styleIcon={{width: 25, height: 25, alignSelf: 'center'}}
                  onPress={() => onChangeTab(item.type, item.tab, index, item)}
                  badge={(item.unread && item.unread) || '0'}
                  badgeStyle={styles.viewBadge}
                />
              );
            })}
        </View>
        <AppText style={styles.titleHeader}>Tất cả</AppText>
        <View>
          {notificationList && (
            <SwipeListView
              data={notificationList}
              renderItem={renderItem}
              renderHiddenItem={renderHiddenItem}
              rightOpenValue={-75}
              onRefresh={onRefreshList}
            />
          )}
          {notificationList && notificationList.length > 0 && (
            <View
              style={{
                justifyContent: 'center',
                alignItems: 'center',
                marginBottom: 30,
              }}>
              <ButtonComponent
                style={{
                  padding: 10,
                  borderWidth: 1,
                  borderColor: '#5d78ff',
                  width: '40%',
                  justifyContent: 'center',
                  alignItems: 'center',
                }}
                onPress={onLoadMore}
                text={'Xem thêm'}
                textStyle={{color: '#5d78ff'}}
              />
            </View>
          )}
        </View>
        {isLoading && <LoadingProgress />}
      </ScrollView>
    </SafeAreaView>
  );
};

export default NotificationMainView;
