import React from 'react';

import {useSelector} from 'react-redux';
import {authSelector, onLeaveSelector} from '../../app/selectors';
import OnLeaveContainer from './onLeaveContainer';

export default function OnLeaveScreen() {
  const authSelect = useSelector(authSelector);
  const onLeaveSelect = useSelector(onLeaveSelector);
  const {
    usersLeavesDayList = [],
    userRestDayList = [],
    approveRequestLeavesDaysList = [],
    leaveCategory = [],
    directManagersList = [],
  } = onLeaveSelect;
  const {userInfo} = authSelect;
  const onLeaveScreenProps = {
    userInfo,
    usersLeavesDayList,
    userRestDayList,
    approveRequestLeavesDaysList,
    leaveCategory,
    directManagersList,
  };
  return <OnLeaveContainer {...onLeaveScreenProps} />;
}
