import {createAsyncThunk, createSlice} from '@reduxjs/toolkit';

import serviceRequest from '../../app/serviceRequest';

import onLeaveApi from '../../api/onLeaveApi';
import Utils from '../../utils';

const initialHome = {
  directManagersList: [],
};

export const getUserLeavesDay = createAsyncThunk(
  'onLeave/getUserLeavesDay',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestGetLeavesDay,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getUserRestDay = createAsyncThunk(
  'onLeave/getUserRestDay',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestGetRestDay,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getApproveRequestLeavesDays = createAsyncThunk(
  'onLeave/getApproveRequestLeavesDays',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestGetLeaveDayApproved,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getLeaveCategory = createAsyncThunk(
  'onLeave/getLeaveCategory',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestGetLeaveCategory,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getDirectManagers = createAsyncThunk(
  'onLeave/getDirectManagers',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestGetDirectManagers,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const postLeaveRequest = createAsyncThunk(
  'onLeave/postLeaveRequest',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestPostLeaveRequest,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const postSubmitApproveLeaveRequest = createAsyncThunk(
  'onLeave/postSubmitApproveLeaveRequest',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: onLeaveApi.requestPostApproveLeaveRequest,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
const onLeaveSlice = createSlice({
  name: 'onLeave',
  initialState: initialHome,
  reducers: {
    handleSelectManagersLeaveRequest: (state, payload) => {
      const {index, value} = payload.payload;
      let managers = JSON.parse(JSON.stringify(state.directManagersList));
      if (managers.length > 0) {
        managers[index].isChecked = value;
        state.directManagersList = [...managers];
      }
    },
  },
  extraReducers: builder => {
    builder.addCase(getUserLeavesDay.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.usersLeavesDayList = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
    builder.addCase(getUserRestDay.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.userRestDayList = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
    builder.addCase(getApproveRequestLeavesDays.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.approveRequestLeavesDaysList = Utils.getValues(
          action,
          'payload.data.collection',
          [],
        );
      }
    });
    builder.addCase(getLeaveCategory.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.leaveCategory = Utils.getValues(action, 'payload.data', []);
      }
    });
    builder.addCase(getDirectManagers.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        const managers = Utils.getValues(action, 'payload.data', []);
        const addKeySelect = managers.map(item => {
          return {
            ...item,
            isChecked: false,
          };
        });
        state.directManagersList = [...addKeySelect];
      }
    });
  },
});

const {reducer, actions} = onLeaveSlice;
export const {handleSelectManagersLeaveRequest} = actions;
export default reducer;
