import {Dimensions, StyleSheet} from 'react-native';
import colors from '../../values/colors';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('window').height;
const styles = StyleSheet.create({
  container: {
    flex: 1,
  },
  pieChartContainer: {
    flexDirection: 'row',
  },
  pieChartView: {
    borderWidth: 1,
    borderColor: 'white',
    borderRadius: 5,
    backgroundColor: 'white',
    marginTop: 10,
    flexDirection: 'row',
    marginLeft: 5,
    marginRight: 10,
    padding: 10,
    width: 190,
  },
  pieItem: {
    alignItems: 'center',
    flex: 1,
  },
  pieFill: {
    position: 'absolute',
    width: 100,
    height: 200,
    alignItems: 'center',
    justifyContent: 'center',
  },
  pieFillTextAmount: {
    fontSize: 13,
    color: '#757575',
  },
  pieFillText: {
    fontSize: 10,
    lineHeight: 15,
  },
  boldTitle: {
    fontWeight: '500',
    marginBottom: 20,
    fontSize: 14,
    color: 'black',
    height: 35,
  },
  h2: {
    fontWeight: '600',
    fontSize: 18,
    color: 'black',
  },
  viewTextPie: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  bgLeftViewTextPie: {
    width: 10,
    height: 10,
  },
  bgRightViewTextPie: {
    backgroundColor: '#0abb87',
    width: 10,
    height: 10,
    marginRight: 5,
  },
  view: {
    width: windowWidth - 10,
    alignSelf: 'center',
    borderWidth: 1,
    borderRadius: 5,
    backgroundColor: colors.white,
    borderColor: colors.white,
    padding: 10,
    marginTop: 10,
  },
  btnConfirm: {
    backgroundColor: '#5d78ff',
    alignItems: 'center',
    justifyContent: 'center',
    borderWidth: 1,
    borderColor: '#5d78ff',
    borderRadius: 8,
    width: windowWidth - 100,
    height: 35,
    flexDirection: 'row',
  },
  whiteTxt: {
    color: colors.white,
    fontWeight: '500',
  },
  blueTxt: {
    color: '#5d78ff',
    fontWeight: '500',
  },
  iconPlus: {
    width: 20,
    height: 20,
    marginRight: 10,
  },
  primary_blue: {
    color: '#5d78ff',
  },
  item: {
    padding: 10,
    marginVertical: 5,
    marginHorizontal: 5,
    borderWidth: 1,
    borderBottomColor: '#f2f2f2',
    borderTopColor: '#f2f2f2',
    borderRightColor: '#f2f2f2',
    borderRadius: 8,
    borderLeftWidth: 3,
    flexDirection: 'row',
    alignItems: 'center',
  },
  title: {
    fontWeight: '500',
    fontSize: 16,
    color: 'black',
  },
  centeredView: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 22,
  },
  modalView: {
    backgroundColor: 'white',
    borderRadius: 20,
    padding: 16,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
    marginTop: 20,
    height: windowHeight,
  },
  modalViewEdit: {
    backgroundColor: 'white',
    borderRadius: 20,
    padding: 16,
    height: windowHeight,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
    marginTop: 20,
  },
  button: {
    borderRadius: 20,
    padding: 10,
    elevation: 2,
  },
  buttonOpen: {
    backgroundColor: '#F194FF',
  },
  buttonClose: {
    backgroundColor: '#2196F3',
  },
  textStyle: {
    color: 'white',
    fontWeight: 'bold',
    textAlign: 'center',
  },
  modalTitle: {
    fontWeight: '500',
    fontSize: 16,
  },
  dropdown1DropdownStyle: {backgroundColor: '#EFEFEF'},
  dropdown1RowStyle: {
    backgroundColor: '#EFEFEF',
    height: 38,
    borderRadius: 4,
  },
  dropdown1RowTxtStyle: {color: '#444', textAlign: 'left', fontSize: 14},
  dropdownSelectTimeText: {color: '#444', textAlign: 'left', fontSize: 14},
  dropdown1BtnStyle: {
    backgroundColor: '#FFF',
    borderWidth: 0.5,
    borderRadius: 8,
    height: 35,
    width: 130,
    fontSize: 12,
    borderColor: '#444',
    color: 'red',
  },
  dropdown1BtnTxtStyle: {color: '#000', fontSize: 14, textAlign: 'center'},
  rowView: {
    flexDirection: 'row',
    marginTop: 10,
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  inputText: {
    backgroundColor: '#FFF',
    paddingLeft: 18,
    marginTop: 4,
  },
  touchableOpacity: {
    flex: 1,
    borderColor: colors.primary_blue,
    borderStyle: 'dotted',
    borderWidth: 1,
    justifyContent: 'center',
    alignItems: 'center',
    height: 100,
    padding: 10,
    width: '35%',
  },
  btnSubmit: {
    backgroundColor: '#5d78ff',
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  btnCancel: {
    backgroundColor: colors.white,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  ImgAvatar: {
    width: 50,
    height: 50,
    borderRadius: 30,
  },
  imgUpload: {
    resizeMode: 'contain',
    height: 90,
    width: 100,
  },
  headerModalBottom: {
    paddingRight: 10,
    paddingLeft: 10,
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  titleModalBottom: {
    fontSize: 16,
    fontWeight: '500',
  },
  bodyModal: {
    flex: 1,
    paddingHorizontal: 10,
    marginTop: 16,
  },
  reason: {
    width: windowWidth / 2 - 25,
    textAlign: 'right',
  },
  textMediumGrey: {
    color: '#757575',
  },
  commonDetail: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    fontSize: 14,
    marginBottom: 12,
    fontFamily: 'Roboto',
  },
  attachment: {
    borderColor: '#c4c4c4',
    borderStyle: 'dashed',
    borderWidth: 0.5,
    borderRadius: 4,
    height: 60,
    width: '50%',
    justifyContent: 'center',
    alignItems: 'center',
    padding: 8,
  },
  checkbox: {
    alignSelf: 'center',
    height: 16,
    width: 16,
    marginRight: 4,
  },
  commentHistories: {
    flex: 1,
    flexDirection: 'row',
    marginBottom: 10,
  },
  avatarApprove: {
    width: 32,
    height: 32,
    borderRadius: 4,
  },
  avatarComment: {
    width: 32,
    height: 32,
    borderRadius: 32,
  },
  commentBox: {
    backgroundColor: '#e5eaf0',
    width: '88%',
    marginLeft: 8,
    paddingHorizontal: 12,
    paddingVertical: 8,
    borderTopRightRadius: 4,
    borderBottomRightRadius: 4,
    borderBottomLeftRadius: 4,
  },
  commentText: {
    marginLeft: 8,
    width: '100%',
    color: '#959595',
    fontSize: 12,
    borderBottomColor: '#5c65dc',
    borderBottomWidth: 1,
    paddingLeft: 8,
    paddingRight: 28,
    paddingVertical: 10,
  },
  bottomModal: {
    height: 50,
    width: '100%',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 8,
  },
  bodyHeight: {
    height: '82%',
  },
  btnAccept: {
    flexDirection: 'row',
    paddingHorizontal: 8,
    paddingVertical: 12,
    backgroundColor: '#5d78ff',
    borderRadius: 4,
  },
  btnReject: {
    flexDirection: 'row',
    paddingHorizontal: 8,
    paddingVertical: 12,
    marginRight: 8,
  },
  wrapperComment: {
    borderColor: '#5d78ff',
    borderStyle: 'dashed',
    borderWidth: 0.5,
    borderRadius: 4,
    height: 60,
    width: '81%',
    padding: 8,
  },
  commentInput: {
    fontSize: 13,
  },
  takeTimeStyle: {
    flex: 1,
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'flex-end',
    borderBottomColor: '#444',
    borderBottomWidth: 0.2,
    height: 24,
  },
  approveRequestTitle: {
    fontWeight: 'bold',
    marginVertical: 10,
    fontSize: 16,
  },
  userAvatarRequest: {
    width: 30,
    height: 30,
    alignSelf: 'center',
    marginRight: 10,
  },
  approveRequestFilter: {
    flexDirection: 'row',
    alignItems: 'center',
    marginVertical: 5,
  },
  leaveRequestEmptyView: {
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'white',
    marginTop: 10,
    padding: 20,
  },
  myLeavesTitleView: {
    flexDirection: 'row',
    marginBottom: 10,
    justifyContent: 'space-between',
    alignItems: 'center',
  },
});
export const leavesModalStyles = StyleSheet.create({
  container: {
    flex: 1,
  },

  whiteTxt: {
    color: colors.white,
    fontWeight: '500',
  },
  blueTxt: {
    color: '#5d78ff',
    fontWeight: '500',
  },

  modalView: {
    backgroundColor: colors.white,
    borderRadius: 20,
    paddingHorizontal: 10,
    shadowColor: colors.black1,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
    marginTop: 100,
    width: '100%',
    height: windowHeight,
  },

  button: {
    borderRadius: 20,
    padding: 10,
    elevation: 2,
  },

  modalTitle: {
    fontWeight: 'bold',
    fontSize: 16,
  },

  rowView: {
    flexDirection: 'row',
    marginTop: 10,
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  inputText: {
    backgroundColor: colors.white,
    width: 200,
  },
  addLeaveRequestImageBtn: {
    borderColor: colors.primary_blue,
    borderStyle: 'dotted',
    borderWidth: 2,
    justifyContent: 'center',
    alignItems: 'center',
    height: 50,
    padding: 10,
    width: 50,
  },
  btnSubmit: {
    backgroundColor: '#5d78ff',
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    paddingHorizontal: 10,
  },
  btnCancel: {
    backgroundColor: colors.white,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  ImgAvatar: {
    width: 50,
    height: 50,
    borderRadius: 30,
  },
  imgUpload: {
    resizeMode: 'contain',
    height: 50,
    width: 50,
    marginRight: 10,
    borderRadius: 5,
  },

  reason: {
    width: windowWidth / 2 - 25,
    textAlign: 'right',
  },

  checkbox: {
    alignSelf: 'center',
    height: 16,
    width: 16,
    marginRight: 4,
  },

  avatarApprove: {
    width: 32,
    height: 32,
    borderRadius: 4,
  },

  takeTimeStyle: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'flex-end',
    borderBottomColor: '#444',
    borderBottomWidth: 0.2,
    height: 24,
  },
  btnClose: {
    width: 20,
    height: 20,
    position: 'absolute',
    top: -5,
    right: 0,
    zIndex: 10,
  },
  chooseTimeSection: {
    alignItems: 'flex-end',
    flexDirection: 'row',
    justifyContent: 'space-between',
    borderBottomWidth: 0.5,
    height: 35,
    width: 200,
    borderColor: colors.grey444,
  },
});
export default styles;
