import Moment from 'moment';
import React from 'react';
import {
  Image,
  SafeAreaView,
  ScrollView,
  TouchableOpacity,
  View,
} from 'react-native';
import FastImage from 'react-native-fast-image';
import PieChart from 'react-native-pie-chart';
import AppText from '../../../components/AppText';
import ButtonComponent from '../../../components/ButtonComponent';
import SelectDropdownComponent from '../../../components/Select';
import config from '../../../config';
import {GifType, IMAGES} from '../../../values/images';
import styles from '../style';
import RequestLeavesDays from './subViews/RequestLeavesDays';
import commonStyles from '../../../styles/commonStyles';

const sliceColorRight = ['#6dc9ee', '#d9f4ff'];
const selectDataDropDown = [
  {label: 'Tất cả', value: 'Tất cả'},
  {label: 'Chưa duyệt', value: 'Chưa duyệt'},
  {label: 'Đã duyệt', value: 'Đã duyệt'},
  {label: 'Đã từ chối', value: 'Đã từ chối'},
];

const DataChartLeavesRestDays = React.memo(
  ({dataChart = []}) => {
    return (
      <View style={styles.pieChartContainer}>
        <ScrollView horizontal={true} showsHorizontalScrollIndicator={false}>
          <View style={{flexDirection: 'row'}}>
            {dataChart?.length > 0 &&
              dataChart.map((item, index) => {
                return (
                  <View
                    key={index}
                    style={[styles.pieChartView, commonStyles.baseShadow]}>
                    <View style={styles.pieItem}>
                      <View style={{marginBottom: 10}}>
                        <AppText style={{textAlign: 'center', fontSize: 12}}>
                          {item.name}
                        </AppText>
                      </View>
                      <View
                        style={{
                          alignItems: 'center',
                          justifyContent: 'center',
                        }}>
                        <PieChart
                          doughnut={true}
                          widthAndHeight={100}
                          series={[
                            item.from < 0
                              ? Math.abs(item.from)
                              : item.from || 0,
                            item.to < 0 ? Math.abs(item.to) : item.to || 1,
                          ]}
                          sliceColor={sliceColorRight}
                          coverRadius={0.9}
                        />
                        <View style={styles.pieFill}>
                          <AppText
                            style={
                              styles.pieFillTextAmount
                            }>{`${item.from} / ${item.to}`}</AppText>
                          <AppText style={styles.pieFillText}> Ngày </AppText>
                        </View>
                      </View>
                      <View>
                        <View style={[styles.viewTextPie, {marginTop: 20}]}>
                          <View
                            style={[
                              styles.bgLeftViewTextPie,
                              {backgroundColor: '#6dc9ee', marginRight: 5},
                            ]}></View>
                          <AppText>Phép đã nghỉ</AppText>
                        </View>
                        <View style={[styles.viewTextPie]}>
                          <View
                            style={[
                              styles.bgLeftViewTextPie,
                              {backgroundColor: '#d9f4ff', marginRight: 10},
                            ]}></View>
                          <AppText>Phép còn lại</AppText>
                        </View>
                      </View>
                    </View>
                  </View>
                );
              })}
          </View>
        </ScrollView>
      </View>
    );
  },
  function areEqual(prevProps, nextProps) {
    return prevProps.dataChart === nextProps.dataChart;
  },
);
const AddNewLeavesSection = React.memo(props => {
  const {onOpenRequestLeavesModal, navigateToConfirmDate, navigateToOverTime} =
    props;
  return (
    <View style={[styles.view, commonStyles.baseShadow]}>
      <AppText style={{fontWeight: '500', marginBottom: 10}}>
        Nghỉ phép của bạn:
      </AppText>
      <View style={{alignItems: 'center', justifyContent: 'center'}}>
        <TouchableOpacity
          style={styles.btnConfirm}
          onPress={onOpenRequestLeavesModal}>
          <Image source={IMAGES.IcBtnAdd} style={styles.iconPlus} />
          <AppText style={styles.whiteTxt}>YÊU CẦU NGHỈ PHÉP</AppText>
        </TouchableOpacity>
      </View>
      <AppText style={{fontWeight: '500', marginBottom: 10, marginTop: 10}}>
        Liên kết nhanh:{' '}
      </AppText>
      <TouchableOpacity
        style={{flexDirection: 'row'}}
        onPress={navigateToConfirmDate}>
        <Image source={IMAGES.IcTask} style={styles.iconPlus} />
        <AppText style={styles.primary_blue}>Xác nhận ngày công</AppText>
      </TouchableOpacity>
      {/* <TouchableOpacity
        onPress={navigateToOverTime}
        style={{flexDirection: 'row', marginTop: 5}}>
        <Image source={IMAGES.IcBackTime} style={styles.iconPlus} />
        <AppText style={styles.primary_blue}>Tăng ca của tôi</AppText>
      </TouchableOpacity> */}
    </View>
  );
});
const ApproveRequestLeavesDays = React.memo(
  props => {
    const {
      onChangeSelectFilter,
      approveRequestLeavesDaysList = [],
      userInfo,
      onOpenDetailModal,
    } = props;
    return (
      <View style={[styles.view, commonStyles.baseShadow]}>
        <View style={styles.approveRequestFilter}>
          <AppText style={styles.approveRequestTitle}>
            Duyệt yêu cầu nghỉ phép
          </AppText>
          <View
            style={{
              alignItems: 'flex-end',
              flex: 1,
            }}>
            <SelectDropdownComponent
              selectData={selectDataDropDown}
              setValue={onChangeSelectFilter}
            />
          </View>
        </View>
        {approveRequestLeavesDaysList.length > 0 &&
          userInfo &&
          approveRequestLeavesDaysList[0].approver_id === userInfo.id &&
          approveRequestLeavesDaysList.map((item, index) => (
            <TouchableOpacity
              key={index}
              style={[
                styles.item,
                {
                  borderLeftColor: item.extend_approved_status_color,
                },
              ]}
              onPress={() => onOpenDetailModal(item)}>
              <View style={{flexDirection: 'row', flex: 2}}>
                <Image
                  source={
                    item.extend_creator_avatar
                      ? {
                          uri:
                            config.imageEndPoint + item.extend_creator_avatar,
                        }
                      : IMAGES.IcAvatarDefault
                  }
                  style={styles.userAvatarRequest}
                />
                <View>
                  <View>
                    <AppText style={styles.title}>
                      {item?.extend_creator_full_name?.length > 18
                        ? item.extend_creator_full_name.slice(0, 18) + '...'
                        : item.extend_creator_full_name}
                    </AppText>
                    <AppText isSubText>
                      {Moment(item.start).format('DD/MM/YYYY')}
                    </AppText>
                  </View>
                </View>
              </View>
              <View style={{flex: 1}}>
                <View style={{flex: 1, alignItems: 'flex-end'}}>
                  <AppText isSubText>{item?.extend_category_name}</AppText>
                  <AppText>{`${item?.extend_taken_days} ngày`}</AppText>
                </View>
              </View>
            </TouchableOpacity>
          ))}
        {/* {leaveList?.length > 0 && !isDisableLoadMore.approveReqBtn && (
        <ButtonComponent
          style={{
            justifyContent: 'center',
            alignItems: 'center',
            padding: 10,
          }}
          text={'Xem thêm'}
          textStyle={{color: '#5d78ff'}}
          onPress={onLoadMoreLeavesApproveReqTicket}
        />
      )} */}
      </View>
    );
  },
  function areEqual(prevProps, nextProps) {
    return (
      prevProps.approveRequestLeavesDaysList === nextProps.approveRequestLeaves
    );
  },
);
const LeavesRequest = React.memo(
  props => {
    const {leaveRequestList, onRefreshLeaveList, onOpenDetailModal} = props;
    return (
      <View style={[styles.view, commonStyles.baseShadow, {marginBottom: 10}]}>
        <View style={styles.myLeavesTitleView}>
          <AppText
            style={{
              fontSize: 17,
            }}>
            Nghỉ phép của tôi:
          </AppText>
          <View style={{alignItems: 'flex-end', paddingRight: 20}}>
            <ButtonComponent
              text={'Tải lại'}
              textStyle={{color: '#5d78ff'}}
              style={{
                flexDirection: 'row',
              }}
              onPress={onRefreshLeaveList}
              leftIcon={IMAGES.IcRefresh}
              styleIcon={{width: 20, height: 20}}
            />
          </View>
        </View>
        {leaveRequestList.length === 0 && (
          <View style={styles.leaveRequestEmptyView}>
            <AppText style={{textAlign: 'center'}}>
              Bạn chưa có ngày nghỉ nào! Vui lòng chọn “Yêu cầu nghỉ phép” ở bên
              trên nhé!
            </AppText>
            <FastImage
              source={GifType.gifLeave}
              style={{width: '90%', height: 250}}
            />
          </View>
        )}
        {leaveRequestList &&
          leaveRequestList.map((item, index) => (
            <TouchableOpacity
              onPress={() => onOpenDetailModal(item, true)}
              key={index}>
              <View
                style={[
                  styles.item,
                  {borderLeftColor: item.extend_approved_status_color},
                ]}>
                <View style={{flex: 2}}>
                  <AppText style={styles.title}>
                    {item.extend_category_name}
                  </AppText>
                  <AppText isSubText>
                    {Moment(item.start).format('DD/MM/YYYY')}
                  </AppText>
                </View>
                <View style={{flex: 1, alignItems: 'flex-end'}}>
                  <AppText>{item.reason}</AppText>
                  <AppText
                    isSubText>{`${item.extend_taken_days} ngày`}</AppText>
                </View>
              </View>
            </TouchableOpacity>
          ))}
        {/* {leaveList && leaveList.length > 0 && !isDisableLoadMore.leaveBtn && (
        <ButtonComponent
          style={{
            justifyContent: 'center',
            alignItems: 'center',
            padding: 10,
          }}
          text={'Xem thêm'}
          textStyle={{color: '#5d78ff'}}
          onPress={onLoadMoreLeavesTicket}
        />
      )} */}
      </View>
    );
  },
  function areEqual(prevProps, nextProps) {
    return prevProps.leaveRequestList === nextProps.leaveRequestList;
  },
);

const OnLeaveMainView = ({
  navigateToConfirmDate,
  navigateToOverTime,
  dataChart,
  onRefreshLeaveList,
  onOpenDetailModal,
  onOpenRequestLeavesModal,
  approveRequestLeavesDaysProps,
  leaveRequestList,
  leavesDaysModal,
  leaveRequestModalProps,
}) => {
  return (
    <SafeAreaView>
      <ScrollView nestedScrollEnabled={true}>
        <DataChartLeavesRestDays dataChart={dataChart} />
        <AddNewLeavesSection
          onOpenRequestLeavesModal={onOpenRequestLeavesModal}
          navigateToConfirmDate={navigateToConfirmDate}
          navigateToOverTime={navigateToOverTime}
        />
        {/* Approve leave request */}
        <ApproveRequestLeavesDays {...approveRequestLeavesDaysProps} />

        <LeavesRequest
          leaveRequestList={leaveRequestList}
          onRefreshLeaveList={onRefreshLeaveList}
          onOpenDetailModal={onOpenDetailModal}
        />
      </ScrollView>
      {leavesDaysModal?.visible && (
        <RequestLeavesDays {...leaveRequestModalProps} />
      )}
    </SafeAreaView>
  );
};

export default OnLeaveMainView;
