import React from 'react';
import {
  Image,
  SafeAreaView,
  ScrollView,
  TouchableOpacity,
  View,
} from 'react-native';

import Moment from 'moment';
import Alert from 'react-native-awesome-alerts';
import {BarChart} from 'react-native-chart-kit';
import SelectDropdown from 'react-native-select-dropdown';
import {GifType, IMAGES} from '../../values/images';

import FastImage from 'react-native-fast-image';
import AppText from '../../components/AppText';
import ButtonComponent from '../../components/ButtonComponent';
import styles from './style';
import Utils from '../../utils';
const OvertimeScreen = ({
  userDetails,
  otVoucherList,
  otApproveReqVoucherList,
  navigateToConfirmDate,
  navigateToOnLeave,
  chartConfig,
  chartData,
  showAlert,
  setShowAlert,
  setMonth,
  isDisableLoadMore,
  onLoadMoreOtList,
  onLoadMoreOtApproveReqList,
  onRefreshOtList,
  onRefreshApproveList,
  modalContent,
  onOpenAddModal,
  onOpenDetailModal,
  payloadOtApproveList,
  onChangeSelectFilter,
}) => {
  //console.log('Moment().month()', Moment().month());
  return (
    <SafeAreaView>
      <ScrollView
        nestedScrollEnabled={true}
        showsVerticalScrollIndicator={false}>
        <View style={styles.barChartContainer}>
          {chartData && (
            <View
              style={{
                ...styles.ChartView,
                overflow: 'scroll',
              }}>
              <View
                style={{
                  flexDirection: 'row',
                  alignItems: 'center',
                  justifyContent: 'space-between',
                }}>
                <View>
                  <AppText style={styles.boldTitle}>Thống kê tăng ca</AppText>
                </View>
                <View
                  style={{
                    flexDirection: 'row',
                    alignItems: 'center',
                    justifyContent: 'flex-end',
                    marginBottom: 16,
                  }}>
                  <AppText style={{marginRight: 8}}>Tháng</AppText>
                  <SelectDropdown
                    data={[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]}
                    defaultValue={Moment().month() + 1}
                    dropdownIconPosition={'right'}
                    buttonStyle={{
                      ...styles.dropdown1BtnStyle,
                      width: '40%',
                      backgroundColor: 'white',
                    }}
                    onSelect={selectedItem => setMonth(selectedItem)}
                    dropdownStyle={{
                      ...styles.dropdown1DropdownStyle,
                    }}
                    rowStyle={styles.dropdown1RowStyle}
                    rowTextStyle={{color: '#444', textAlign: 'center'}}
                    buttonTextStyle={{color: '#444', textAlign: 'center'}}
                  />
                </View>
              </View>

              <AppText style={{fontWeight: 'bold'}}>Tần suất</AppText>
              <ScrollView horizontal={true} style={{marginTop: 8}}>
                <BarChart
                  data={chartData}
                  width={3000}
                  height={220}
                  chartConfig={chartConfig}
                  withInnerLines={false}
                />
              </ScrollView>
              <AppText style={{fontWeight: 'bold', textAlign: 'right'}}>
                Ngày
              </AppText>
            </View>
          )}
        </View>

        <View style={styles.view}>
          <AppText style={{fontWeight: '500', marginBottom: 10}}>
            Tăng ca của bạn:{' '}
          </AppText>
          <View style={{alignItems: 'center', justifyContent: 'center'}}>
            <TouchableOpacity
              style={styles.btnConfirm}
              onPress={() => {
                onOpenAddModal();
              }}>
              <Image source={IMAGES.IcBtnAdd} style={styles.iconPlus} />
              <AppText style={styles.whiteTxt}>YÊU CẦU TĂNG CA</AppText>
            </TouchableOpacity>
          </View>
          <AppText style={{fontWeight: '500', marginBottom: 10, marginTop: 10}}>
            Liên kết nhanh:{' '}
          </AppText>
          <TouchableOpacity
            style={{flexDirection: 'row'}}
            onPress={navigateToConfirmDate}>
            <Image source={IMAGES.IcTask} style={styles.iconPlus} />
            <AppText style={styles.primary_blue}>Xác nhận ngày công</AppText>
          </TouchableOpacity>
          <TouchableOpacity
            onPress={navigateToOnLeave}
            style={{flexDirection: 'row', marginTop: 5}}>
            <Image source={IMAGES.IcBackTime} style={styles.iconPlus} />
            <AppText style={styles.primary_blue}>Nghỉ phép của tôi</AppText>
          </TouchableOpacity>
        </View>

        {/**Approve Request */}
        {otApproveReqVoucherList && (
          <View style={[styles.view, {marginBottom: 10}]}>
            <View style={{marginBottom: 10, flexDirection: 'row'}}>
              <AppText
                style={{
                  fontWeight: 'bold',
                  marginBottom: 10,
                  flex: 2,
                  fontSize: 17,
                }}>
                Duyệt yêu cầu tăng ca{' '}
              </AppText>
              <View style={{alignItems: 'flex-end', flex: 1, paddingRight: 20}}>
                <SelectDropdown
                  data={['Tất cả', 'Chưa duyệt', 'Đã duyệt', 'Đã từ chối']}
                  dropdownIconPosition={'right'}
                  defaultButtonText={payloadOtApproveList?.type}
                  buttonStyle={styles.dropdown1BtnStyle}
                  onSelect={selectedItem => onChangeSelectFilter(selectedItem)}
                  dropdownStyle={styles.dropdown1DropdownStyle}
                  rowStyle={styles.dropdown1RowStyle}
                  rowTextStyle={styles.dropdown1RowTxtStyle}
                  buttonTextStyle={styles.dropdown1BtnTxtStyle}
                  renderDropdownIcon={isOpened => {
                    return (
                      <Image
                        source={
                          isOpened ? IMAGES.IcUpArrow : IMAGES.IcArrowDown
                        }
                        style={{width: 20, height: 20}}
                      />
                    );
                  }}
                />
              </View>
            </View>
            {otApproveReqVoucherList?.length > 0 &&
              //otApproveReqVoucherList[0]?.approver_id == userDetails.id &&
              otApproveReqVoucherList.map((item, index) => (
                <TouchableOpacity
                  key={index}
                  style={[
                    styles.item,
                    {
                      borderLeftColor: item?.extend_approved_status_color,
                    },
                  ]}
                  onPress={() => {
                    onOpenDetailModal(item?.id);
                  }}>
                  <View
                    style={{
                      flexDirection: 'row',
                      flex: 2,
                      alignItems: 'center',
                    }}>
                    <Image
                      source={{
                        uri:
                          'https://meu.anawork.com' +
                          item.extend_creator_avatar,
                      }}
                      style={{
                        width: 40,
                        height: 40,
                        marginRight: 10,
                        borderRadius: 8,
                      }}
                    />
                    <View
                      style={{
                        flexDirection: 'row',
                        alignItems: 'center',
                        justifyContent: 'space-between',
                      }}>
                      <View>
                        <AppText style={{...styles.title, marginBottom: 4}}>
                          {item.extend_creator_full_name}
                        </AppText>
                        <AppText>
                          {Moment(item.start).format('DD/MM/YYYY')} -{' '}
                          {Moment(item.finish).format('DD/MM/YYYY')}
                        </AppText>
                      </View>
                    </View>
                  </View>
                  <View
                    style={{
                      flex: 1,
                      alignItems: 'flex-end',
                      marginLeft: 10,
                    }}>
                    <AppText style={{textAlign: 'right'}}>
                      {item.reason}
                    </AppText>
                    <AppText style={{textAlign: 'right'}}>{`${Moment(
                      item.finish,
                    ).diff(Moment(item.start), 'hours')} giờ`}</AppText>
                  </View>
                </TouchableOpacity>
              ))}
            {!isDisableLoadMore.approveRequestBtn &&
              otApproveReqVoucherList?.length > 0 && (
                <ButtonComponent
                  style={{
                    justifyContent: 'center',
                    alignItems: 'center',
                    padding: 10,
                  }}
                  text={'Xem thêm'}
                  textStyle={{color: '#5d78ff'}}
                  onPress={onLoadMoreOtApproveReqList}
                />
              )}
          </View>
        )}
        {/* My  OT*/}
        <View style={[styles.view, {marginBottom: 30}]}>
          <View style={{flexDirection: 'row', marginBottom: 10}}>
            <AppText
              style={{
                fontWeight: 'bold',
                marginBottom: 10,
                flex: 1,
                fontSize: 17,
                alignSelf: 'center',
              }}>
              Tăng ca của tôi
            </AppText>
            <View style={{alignItems: 'flex-end', flex: 1, paddingRight: 20}}>
              <ButtonComponent
                text={'Tải lại'}
                textStyle={{color: '#5d78ff'}}
                style={{
                  justifyContent: 'center',
                  alignItems: 'center',
                  padding: 10,
                  flexDirection: 'row',
                }}
                onPress={onRefreshOtList}
                leftIcon={IMAGES.IcRefresh}
                styleIcon={{width: 20, height: 20}}
              />
            </View>
          </View>
          {/**Gif */}
          {otVoucherList.length === 0 && (
            <View
              style={{
                justifyContent: 'center',
                alignItems: 'center',
                backgroundColor: 'white',
                marginTop: 10,
                padding: 20,
              }}>
              <AppText style={{textAlign: 'center'}}>
                Chưa có tăng ca nào 🧐 Bạn vui lòng thêm “yêu cầu tăng ca” ngay
                bên trên nhé!
              </AppText>
              <FastImage
                source={GifType.gifOt}
                style={{width: '90%', height: 250}}
              />
            </View>
          )}
          {otVoucherList.map((item, index) => (
            <TouchableOpacity
              key={index}
              style={{
                ...styles.item,
                borderLeftColor: item.extend_approved_status_color,
              }}
              onPress={() => {
                onOpenDetailModal(item?.id);
              }}>
              <View style={{flex: 3, alignItems: 'flex-start'}}>
                <AppText
                  style={{...styles.title, marginBottom: 6}}
                  numberOfLines={1}>
                  {item.reason}
                </AppText>
                <AppText>{`${Moment(item.start).format(
                  'DD/MM/YYYY',
                )} - ${Moment(item.finish).format('DD/MM/YYYY')}`}</AppText>
              </View>
              <View
                style={{
                  flex: 1,
                  alignItems: 'flex-end',
                  justifyContent: 'flex-end',
                }}>
                <AppText>{''}</AppText>
                <AppText style={{textAlign: 'right'}}>
                  {Utils.minutesToHours(item.start, item.finish)}
                </AppText>
              </View>
            </TouchableOpacity>
          ))}
          {otVoucherList?.length > 0 && !isDisableLoadMore.overtimeBtn && (
            <ButtonComponent
              style={{
                justifyContent: 'center',
                alignItems: 'center',
                padding: 10,
              }}
              text={'Xem thêm'}
              textStyle={{color: '#5d78ff'}}
              onPress={onLoadMoreOtList}
            />
          )}
        </View>

        {/* Alert */}
        <Alert
          show={showAlert.isShow}
          showProgress={false}
          title={showAlert.title}
          message={showAlert.message}
          closeOnTouchOutside={true}
          closeOnHardwareBackPress={false}
          showConfirmButton={true}
          confirmText="Đóng"
          confirmButtonColor="#DD6B55"
          onConfirmPressed={() =>
            setShowAlert({
              ...showAlert,
              isShow: false,
            })
          }
        />
        {modalContent}
      </ScrollView>
    </SafeAreaView>
  );
};

export default OvertimeScreen;
