import {Dimensions, StyleSheet} from 'react-native';
import colors from '../../values/colors';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('window').height;
const styles = StyleSheet.create({
  barChartContainer: {
    flexDirection: 'row',
    justifyContent: 'space-around',
  },
  ChartView: {
    borderWidth: 1,
    borderColor: 'white',
    borderRadius: 5,
    backgroundColor: 'white',
    marginTop: 10,
    padding: 20,
    width: windowWidth - 10,
  },
  boldTitle: {
    fontWeight: '500',
    marginBottom: 20,
    fontSize: 16,
    color: 'black',
  },
  h2: {
    fontWeight: '500',
    fontSize: 20,
    color: 'black',
  },
  viewTextPie: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'flex-start',
  },
  bgLeftViewTextPie: {
    backgroundColor: '#6dc9ee',
    width: 10,
    height: 10,
    marginRight: 5,
  },
  bgRightViewTextPie: {
    backgroundColor: '#0abb87',
    width: 10,
    height: 10,
    marginRight: 5,
  },
  view: {
    width: windowWidth - 10,
    alignSelf: 'center',
    borderWidth: 1,
    borderRadius: 5,
    backgroundColor: colors.white,
    borderColor: colors.white,
    padding: 10,
    marginTop: 10,
  },
  btnConfirm: {
    backgroundColor: '#5d78ff',
    alignItems: 'center',
    justifyContent: 'center',
    borderWidth: 1,
    borderColor: '#5d78ff',
    borderRadius: 8,
    width: windowWidth - 100,
    height: 40,
    flexDirection: 'row',
  },
  whiteTxt: {
    color: colors.white,
    fontWeight: '500',
  },

  blueTxt: {
    color: '#5d78ff',
    fontWeight: '500',
  },
  iconPlus: {
    width: 20,
    height: 20,
    marginRight: 10,
  },
  primary_blue: {
    color: '#5d78ff',
  },
  item: {
    padding: 15,
    marginVertical: 5,
    marginHorizontal: 16,
    borderWidth: 1,
    borderBottomColor: '#f2f2f2',
    borderTopColor: '#f2f2f2',
    borderRightColor: '#f2f2f2',
    borderTopLeftRadius: 10,
    borderBottomLeftRadius: 10,
    borderTopRightRadius: 10,
    borderBottomRightRadius: 10,
    borderLeftWidth: 5,
    flexDirection: 'row',
  },
  title: {
    fontWeight: '500',
    fontSize: 14,
    color: 'black',
  },
  centeredView: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 22,
  },
  modalView: {
    backgroundColor: 'white',
    borderRadius: 20,
    padding: 20,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
    marginTop: 20,
    height: windowHeight,
  },
  button: {
    borderRadius: 20,
    padding: 10,
    elevation: 2,
  },
  buttonOpen: {
    backgroundColor: '#F194FF',
  },
  buttonClose: {
    backgroundColor: '#2196F3',
  },
  textStyle: {
    color: 'white',
    fontWeight: 'bold',
    textAlign: 'center',
  },
  modalTitle: {
    fontWeight: '500',
    fontSize: 16,
  },
  dropdown1DropdownStyle: {backgroundColor: '#EFEFEF'},
  dropdown1RowStyle: {
    backgroundColor: '#EFEFEF',
    height: 38,
    borderRadius: 4,
  },
  dropdown1RowTxtStyle: {color: '#444', textAlign: 'left', fontSize: 14},
  dropdownSelectTimeText: {color: '#444', textAlign: 'left', fontSize: 14},
  dropdown1BtnStyle: {
    backgroundColor: '#FFF',
    borderWidth: 0.5,
    borderRadius: 8,
    height: 35,
    width: 130,
    fontSize: 12,
    borderColor: '#444',
  },
  dropdown1BtnTxtStyle: {color: '#000', fontSize: 14, textAlign: 'center'},
  rowView: {
    flexDirection: 'row',
    marginTop: 10,
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  inputText: {
    width: '40%',
    height: 40,
    backgroundColor: '#FFF',
    borderBottomWidth: 0.2,
    borderColor: '#444',
  },
  inputTextArea: {
    width: '40%',
    backgroundColor: '#FFF',
    borderBottomWidth: 0.2,
    borderColor: '#444',
    textAlign: 'right',
  },
  touchableOpacity: {
    borderColor: colors.primary_blue,
    borderStyle: 'dotted',
    borderWidth: 2,
    justifyContent: 'center',
    alignItems: 'center',
    height: 80,
    padding: 10,
    width: '40%',
  },
  viewOpenGallery: {
    borderColor: colors.primary_blue,
    borderStyle: 'dotted',
    borderWidth: 2,
    justifyContent: 'center',
    alignItems: 'center',
    height: 50,
    padding: 10,
    width: 50,
  },
  btnSubmit: {
    backgroundColor: '#5d78ff',
    justifyContent: 'center',
    alignItems: 'center',
    borderRadius: 8,
  },
  btnDelete: {
    backgroundColor: 'red',
    justifyContent: 'center',
    alignItems: 'center',
    borderRadius: 8,
  },
  btnCancel: {
    backgroundColor: colors.white,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  ImgAvatar: {
    width: 50,
    height: 50,
    borderRadius: 30,
  },
  imgUpload: {
    resizeMode: 'contain',
    height: 90,
    width: 100,
  },
  radioButton: {
    height: 30,
    width: 30,
    borderColor: '#5d78ff',
    borderWidth: 2,
    borderRadius: 50,
  },
});

export default styles;
